package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.sal.marketing.commons.enums.ResultType;

/**
 * Created by liuxp on 16/1/19.
 */
public class ResultWrapper<T> {
    private ResultType retType = ResultType.SUCC;// 返回结果
    private String retDesc;// 返回结果描述
    private T data;

    public ResultType getRetType() {
        return retType;
    }

    public ResultWrapper<T> setRetType(ResultType retType) {
        this.retType = retType;
        return this;
    }

    public String getRetDesc() {
        return retDesc;
    }

    public ResultWrapper<T> setRetDesc(String retDesc) {
        this.retDesc = retDesc;
        return this;
    }

    public T getData() {
        return data;
    }

    public ResultWrapper<T> setData(T data) {
        this.data = data;
        return this;
    }

    public static <T> ResultWrapper<T> getInstance(boolean success) {
        return new ResultWrapper<T>().setRetType(success ? ResultType.SUCC : ResultType.FAIL);
    }

}
