package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sal.marketing.activity.enums.ContentType;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;

/**
 * @author Rezar
 * @createDate :Jan 10, 2016 10:46:03 PM
 * @desc :
 */
public class ActivityRequest extends Request {

    public static final Integer BB_TYPE = BlackBoardType.NOTICE.getType();
    public static final Integer C_TYPE = ContentType.XIANSHANG_BAOMING.getType(); // 暂定为其他

    // 标题
    private String name;
    // 正文
    private String content;
    // 活动开始时间
    private Long startTime;
    // 活动结束时间
    private Long endTime;
    // 报名人数限制：-1=无限制
    private Integer countLimit;
    // 报名结束时间
    private Long enrollDeadline;
    // 经度
    private String longitude;
    // 维度
    private String latitude;
    // 活动地址
    private String address;
    // 地域ID，需要app端进行值的传递
    private String addressDetail;
    private Long areaId;
    // 自定义配置信息
    private String customConf;
    // 模板id
    private Integer templateId;
    // 模板类型id
    private Integer templateTypeId;

    public String getAddressDetail() {
        return addressDetail;
    }

    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    public Integer getTemplateTypeId() {
        return templateTypeId;
    }

    public void setTemplateTypeId(Integer templateTypeId) {
        this.templateTypeId = templateTypeId;
    }

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getEnrollDeadline() {
        return enrollDeadline;
    }

    public void setEnrollDeadline(Long enrollDeadline) {
        this.enrollDeadline = enrollDeadline;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getCustomConf() {
        return customConf;
    }

    public void setCustomConf(String customConf) {
        this.customConf = customConf;
    }

    public ActivityConfigDto getConfig() {
        ActivityConfigDto ac = new ActivityConfigDto();
        BussinessPreconditions.checkArgument((GenericsUtils.notNullAndEmpty(this.addressDetail)||GenericsUtils.notNullAndEmpty(this.getAddress())),"请填写活动地址");
        ac.setAreaId(areaId);
        ac.setStartTime(startTime);
        ac.setEndTime(endTime);
        ac.setEnrollDeadline(enrollDeadline);
        ac.setLatitude(latitude);
        ac.setLongitude(longitude);
        ac.setDisplay(1);
        ac.setCountLimit(this.countLimit);
        ac.setCustomConf(customConf);
        ac.setTemplateId(this.templateId);
        ac.setTemplateTypeId(this.templateTypeId);
        ac.setAddress(address);
        ac.setAddressDetail(this.addressDetail);
        return ac;
    }
    public ActivityConfigDto getConfigWhenUpdate() {
        ActivityConfigDto ac = new ActivityConfigDto();
        ac.setAddress(address);
        ac.setAreaId(areaId);
        ac.setStartTime(startTime);
        ac.setEndTime(endTime);
        ac.setEnrollDeadline(enrollDeadline);
        ac.setLatitude(latitude);
        ac.setLongitude(longitude);
        ac.setDisplay(1);
        ac.setCountLimit(this.countLimit);
        ac.setCustomConf(customConf);
        ac.setTemplateId(this.templateId);
        ac.setTemplateTypeId(this.templateTypeId);
        if(GenericsUtils.notNullAndEmpty(addressDetail)) {
            ac.setAddressDetail(this.addressDetail);
        }
        return ac;
    }
    @Override
    public String toString() {
        return "ActivityRequest [name=" + name + ", content=" + content + ", startTime=" + startTime + ", endTime="
            + endTime + ", countLimit=" + countLimit + ", enrollDeadline=" + enrollDeadline + ", longitude=" + longitude
            + ", latitude=" + latitude + ", address=" + address + ", areaId=" + areaId + ", customConf=" + customConf
            + ", templateId=" + templateId + ", templateTypeId=" + templateTypeId + ", addressDetail=" + addressDetail + "]";
    }

}
