/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.smsGroupSend.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.CourseDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendListDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendRequest;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.service.SmsGroupSendService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsGroupSendServiceImpl
implements SmsGroupSendService {
    private static final Logger log = LoggerFactory.getLogger(SmsGroupSendServiceImpl.class);
    @Autowired
    private SmsGroupSendRecordDao smsGroupSendRecordDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentCourseDao orgStudetnCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    public static final String KEY_FORMAT = "%s:%s";
    private LoadingCache<String, SmsGroupSendListDto> records = CacheBuilder.newBuilder().maximumSize(2000L).build((CacheLoader)new CacheLoader<String, SmsGroupSendListDto>(){

        public SmsGroupSendListDto load(String key) throws Exception {
            if (GenericsUtils.isNullOrEmpty((Object)key)) {
                return null;
            }
            TwoTuple<Long, Long> orgAndRecordIds = this.extractIds(key);
            log.info("orgId is : {} and recordId is : {} ", orgAndRecordIds.first, orgAndRecordIds.second);
            SmsGroupSendRecord byId = SmsGroupSendServiceImpl.this.smsGroupSendRecordDao.searchRecordWithOrgId((Long)orgAndRecordIds.second, (Long)orgAndRecordIds.first);
            if (byId != null) {
                List<SmsGroupSendListDto> buildSmsGroupSendListDto = SmsGroupSendServiceImpl.this.buildSmsGroupSendListDto(Lists.newArrayList((Object[])new SmsGroupSendRecord[]{byId}));
                return buildSmsGroupSendListDto.get(0);
            }
            return null;
        }

        private TwoTuple<Long, Long> extractIds(String key) {
            String[] orgIdAndRecordId = key.split(":");
            String orgIdStr = orgIdAndRecordId[0];
            String recordIdStr = orgIdAndRecordId[1];
            Long recordId = Long.parseLong(recordIdStr);
            Long orgId = Long.parseLong(orgIdStr);
            return TupleUtil.tuple((Object)orgId, (Object)recordId);
        }

        public Map<String, SmsGroupSendListDto> loadAll(Iterable<? extends String> keys) throws Exception {
            if (GenericsUtils.isNullOrEmpty(keys)) {
                return GenericsUtils.emptyMap();
            }
            HashMap orgRecordIds = Maps.newHashMap();
            for (String string : keys) {
                TwoTuple<Long, Long> extractIds = this.extractIds(string);
                if (orgRecordIds.get(extractIds.first) == null) {
                    orgRecordIds.put(extractIds.first, Lists.newArrayList(Arrays.asList((Long)extractIds.second)));
                    continue;
                }
                ((List)orgRecordIds.get(extractIds.first)).add(extractIds.second);
            }
            HashMap dtoMaps = Maps.newHashMap();
            for (final Long orgId : orgRecordIds.keySet()) {
                HashSet newHashSet = Sets.newHashSet((Iterable)((Iterable)orgRecordIds.get(orgId)));
                List byIds = SmsGroupSendServiceImpl.this.smsGroupSendRecordDao.searchRecordsWithOrgId(orgId, (Collection)newHashSet);
                List<SmsGroupSendListDto> buildSmsGroupSendListDto = SmsGroupSendServiceImpl.this.buildSmsGroupSendListDto(byIds);
                dtoMaps.putAll(CollectionUtils.extractMap(buildSmsGroupSendListDto, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, SmsGroupSendListDto>(){

                    public String extract(SmsGroupSendListDto arg0) {
                        return String.format(SmsGroupSendServiceImpl.KEY_FORMAT, orgId, arg0.getRecordId());
                    }
                }));
            }
            return dtoMaps;
        }
    });

    @Override
    public SmsGroupSendResp pullStuOrCourseInfos(SmsGroupSendRequest request) {
        log.info("request1 is : {} ", (Object)request);
        SmsGroupSendResp resp = new SmsGroupSendResp();
        SmsGroupSendRecord record = null;
        List<StudentDto> studentDtos = null;
        List<CourseDto> courseDtos = null;
        if (request.getRecordId() != null) {
            record = this.smsGroupSendRecordDao.searchRecordWithOrgId(request.getRecordId(), request.getOrgId());
            if (record == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u5f53\u524d\u673a\u6784\u6ca1\u6709\u8be5\u7fa4\u53d1\u8bb0\u5f55");
            }
            Long orgId = request.getOrgId();
            request = new SmsGroupSendRequest();
            request.setOrgId(orgId);
            request.setStudentIds(record.getAllReceiver());
            request.setNeedDistinct(true);
            studentDtos = this.getAllStudents(request);
            int limit = Integer.parseInt(GenericsUtils.isNullOrEmpty((Object)Config.LOCAL_BATCH_SEND_COUNT_LIMIT) ? "100" : Config.LOCAL_BATCH_SEND_COUNT_LIMIT);
            if (studentDtos.size() > limit) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672c\u5730\u53d1\u9001\u77ed\u4fe1\u63a5\u6536\u4eba\u8fc7\u591a\uff0c\u5efa\u8bae\u9650\u5236\u63a5\u6536\u4eba\u7684\u6570\u91cf\u4ee5\u907f\u514d\u53d1\u9001\u65f6\u95f4\u8fc7\u957f");
            }
        } else {
            PageDto pageDto = new PageDto();
            pageDto.setPageNum(Integer.valueOf(1));
            pageDto.setPageSize(Integer.valueOf(10));
            request.setPageDto(pageDto);
            studentDtos = this.searchStudents(request);
            courseDtos = this.searchCourses(request);
        }
        resp.setCourses(courseDtos);
        resp.setStudents(studentDtos);
        return resp;
    }

    @Override
    public List<StudentDto> getAllStudents(SmsGroupSendRequest request) {
        List<StudentDto> studentDtos = this.searchStudents(request);
        List<StudentDto> courseStus = this.searchStudentsFromCourse(request);
        studentDtos.addAll(courseStus);
        return studentDtos;
    }

    protected List<SmsGroupSendListDto> buildSmsGroupSendListDto(List<SmsGroupSendRecord> listAllSmsGroupRecords) {
        if (GenericsUtils.isNullOrEmpty(listAllSmsGroupRecords)) {
            return GenericsUtils.emptyList();
        }
        Long orgId = listAllSmsGroupRecords.get(0).getOrgId();
        ArrayList dtos = Lists.newArrayList();
        for (SmsGroupSendRecord record : listAllSmsGroupRecords) {
            log.info("record is : {} ", (Object)record);
            String receivers = record.getAllReceiver();
            SmsGroupSendRequest request = new SmsGroupSendRequest();
            request.setStudentIds(receivers);
            request.setOrgId(orgId);
            List<StudentDto> allNames = this.searchStudents(request);
            SmsGroupSendListDto newInstance = SmsGroupSendListDto.newInstance(record, allNames);
            dtos.add(newInstance);
        }
        return dtos;
    }

    private List<StudentDto> searchStudentsFromCourse(SmsGroupSendRequest request) {
        List<Long> courseIds = request.getCourseIdList();
        Long orgId = request.getOrgId();
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (accountById == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NO_LOGIN, "\u975e\u6cd5\u8bbf\u95ee");
        }
        ArrayList noDelCourseIds = Lists.newArrayList();
        List orgCourseList = this.orgCourseDao.getOrgCourseList(Arrays.asList(accountById.getNumber()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        for (OrgCourse orgCourse : orgCourseList) {
            if (orgCourse.getIsDel() != 0) continue;
            noDelCourseIds.add(orgCourse.getId());
        }
        log.info("noDelCourseIds : {} ", (Object)noDelCourseIds);
        HashSet filterIds = Sets.newHashSet(courseIds);
        List allStudetnIds = this.orgStudetnCourseDao.searchStudentWithCourseIds(orgId, (Set)filterIds, (List)noDelCourseIds, request.isAllCourse());
        ArrayList studentIds = Lists.newArrayList();
        for (OrgStudentCourse orgStudent : allStudetnIds) {
            studentIds.add(orgStudent.getUserId());
        }
        log.info("studentIds is : {} ", (Object)studentIds);
        List orgStudents = this.orgStudentDao.getStudentByUserIds(orgId, (Collection)studentIds, new String[]{"id", "name", "userId", "nickName", "mobile", "avatar"});
        log.info("studentPO are : {} ", (Object)orgStudents);
        return this.buildStudentDto(orgStudents, orgId, request.isNeedDistinct());
    }

    private List<CourseDto> searchCourses(SmsGroupSendRequest request) {
        List<Long> courseIds = request.getCourseIdList();
        Long orgId = request.getOrgId();
        HashSet filterIds = Sets.newHashSet(courseIds);
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (accountById == null) {
            log.info("can not find orgAccount with orgId : {} ", (Object)accountById);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NO_LOGIN, "\u5f53\u524d\u673a\u6784\u4e0d\u5b58\u5728");
        }
        List allCourses = this.orgCourseDao.searchCourses(Long.valueOf(accountById.getNumber().longValue()), (Set)filterIds, request.isAllCourse(), null, null, null, request.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)allCourses)) {
            return GenericsUtils.emptyList();
        }
        ArrayList courseDtos = Lists.newArrayList();
        if (GenericsUtils.notNullAndEmpty((Object)allCourses)) {
            for (OrgCourse orgCourse : allCourses) {
                CourseDto dto = CourseDto.buildDto(orgCourse);
                courseDtos.add(dto);
            }
        }
        return courseDtos;
    }

    private List<StudentDto> searchStudents(SmsGroupSendRequest request) {
        HashSet<Long> filterIds;
        List<Long> studentIds = request.getStudentIdList();
        Long orgId = request.getOrgId();
        List searchStudent = this.orgStudentDao.searchStudent(orgId, filterIds = new HashSet<Long>(studentIds), request.isAllStudent(), request.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)searchStudent)) {
            return GenericsUtils.emptyList();
        }
        return this.buildStudentDto(searchStudent, orgId, request.isNeedDistinct());
    }

    private List<StudentDto> buildStudentDto(List<OrgStudent> searchStudent, Long orgId, boolean needDistinct) {
        if (GenericsUtils.isNullOrEmpty(searchStudent)) {
            return GenericsUtils.emptyList();
        }
        ArrayList studentDtos = Lists.newArrayList();
        HashSet mobiles = Sets.newHashSet();
        for (OrgStudent student : searchStudent) {
            String mobile = student.getStudentMobile();
            if (needDistinct && (!GenericsUtils.notNullAndEmpty((Object)mobile) || mobile.contains("****") || !mobiles.add(mobile))) continue;
            StudentDto studentDto = new StudentDto();
            studentDto.setId(student.getId());
            Long userId = student.getUserId();
            String name = student.getName();
            name = GenericsUtils.isNullOrEmpty((Object)name) ? student.getNickName() : name;
            studentDto.setName(name);
            studentDto.setMobile(mobile);
            studentDto.setUserId(userId);
            studentDtos.add(studentDto);
        }
        Map studentAvatarUrlMap = this.studentApiService.batchGetStudentAvatarUrl(searchStudent);
        for (StudentDto dto : studentDtos) {
            String avatarUrl = (String)studentAvatarUrlMap.get(dto.getId());
            if (avatarUrl == null) continue;
            dto.setAvatarUrl(avatarUrl);
        }
        return studentDtos;
    }

    @Override
    public List<SmsGroupSendListDto> listSendRecord(final Long orgId, Long lastRecordId, PageDto pageDto) {
        ArrayList ret;
        ArrayList immutableKeys;
        block7: {
            List listAllSmsGroupRecords = this.smsGroupSendRecordDao.listAllSmsGroupRecords(orgId, lastRecordId, pageDto, new String[]{"id"});
            if (GenericsUtils.isNullOrEmpty((Object)listAllSmsGroupRecords)) {
                return GenericsUtils.emptyList();
            }
            LinkedHashSet allRecordIds = Sets.newLinkedHashSet((Iterable)CollectionUtils.extractList((Collection)listAllSmsGroupRecords, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, SmsGroupSendRecord>(){

                public String extract(SmsGroupSendRecord arg0) {
                    return String.format(SmsGroupSendServiceImpl.KEY_FORMAT, orgId, arg0.getId());
                }
            }));
            immutableKeys = Lists.newArrayList((Iterable)allRecordIds);
            ret = Lists.newArrayList();
            ImmutableMap allPresent = this.records.getAllPresent((Iterable)allRecordIds);
            ret.addAll(allPresent.values());
            ImmutableSet keySet = allPresent.keySet();
            allRecordIds.removeAll((Collection<?>)keySet);
            try {
                if (!GenericsUtils.notNullAndEmpty((Object)allRecordIds)) break block7;
                log.info("allRecordIds are : {} ", (Object)allRecordIds);
                ImmutableMap all = this.records.getAll((Iterable)allRecordIds);
                if (all == null) break block7;
                ret.addAll(all.values());
            }
            catch (Exception e) {
                log.error("can not get all from cache , and will get it from for-each ", (Throwable)e);
                for (String record : allRecordIds) {
                    try {
                        ret.add(this.records.get((Object)record));
                    }
                    catch (Exception e1) {
                        log.error("", (Throwable)e1);
                    }
                }
            }
        }
        Map retMap = CollectionUtils.extractMap((Collection)ret, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, SmsGroupSendListDto>(){

            public String extract(SmsGroupSendListDto arg0) {
                return String.format(SmsGroupSendServiceImpl.KEY_FORMAT, orgId, arg0.getRecordId());
            }
        });
        ret.clear();
        for (String key : immutableKeys) {
            ret.add(retMap.get(key));
        }
        return SmsGroupSendListDto.buildTurncatureResp(ret);
    }

    @Override
    public boolean markSendStatus(Long recordId, Long orgId, String failureStuIds) {
        log.info("will markSendStatus for orgId : {}  recordId: {} ", (Object)recordId, (Object)orgId);
        try {
            SmsGroupSendRecord searchRecordWithOrgId = this.smsGroupSendRecordDao.searchRecordWithOrgId(recordId, orgId);
            if (searchRecordWithOrgId == null) {
                log.info("can not find the record with orgId:{} and recordId:{} ", (Object)orgId, (Object)recordId);
                return false;
            }
            searchRecordWithOrgId.setSendStatus(SendStatus.SEND_OK.getCode().intValue());
            searchRecordWithOrgId.setSendTime(new Timestamp(System.currentTimeMillis()));
            this.records.invalidate((Object)String.format(KEY_FORMAT, orgId, recordId));
            this.smsGroupSendRecordDao.saveOrUpdate((Object)searchRecordWithOrgId, new String[0]);
            return true;
        }
        catch (Exception e) {
            log.error("can not markSendStatus cause by : {} ", (Throwable)e);
            return false;
        }
    }

    @Override
    public SmsGroupSendListDto getSmsGroupSendRecordDetail(Integer orgId, Long recordId) {
        SmsGroupSendListDto sarchRecordWithOrgId = null;
        try {
            sarchRecordWithOrgId = (SmsGroupSendListDto)this.records.get((Object)String.format(KEY_FORMAT, orgId, recordId));
            if (sarchRecordWithOrgId == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u673a\u6784\u6ca1\u6709\u6539\u7fa4\u53d1\u8bb0\u5f55");
            }
        }
        catch (Exception e) {
            log.error("can not getSmsGroupSendRecordDetail from cache or db cause by : ", (Throwable)e);
        }
        return sarchRecordWithOrgId;
    }
}

