/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtils {
    private static final Logger log = LoggerFactory.getLogger(MailUtils.class);
    public static final String beginToSend = "BeginToSend";
    public static final String delivered = "Delivered";
    public static final String partiallyDelivered = "PartiallyDelivered";
    public static final String notDelivered = "NotDelivered";

    public static Session createSession(String host, final String username, final String password) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp.auth", "true");
        prop.setProperty("mail.smtp.connectiontimeout", String.valueOf(60000));
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
        return Session.getInstance((Properties)prop, (Authenticator)auth);
    }

    public static Session createSession(String host) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp,auth", "false");
        prop.setProperty("mail.smtp.connectiontimeout", String.valueOf(60000));
        return Session.getInstance((Properties)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Session session, final Mail mail) throws MessagingException, IOException {
        String bcc;
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(mail.getFrom()));
        msg.addRecipients(Message.RecipientType.TO, mail.getToAddress());
        String cc = mail.getCcAddress();
        if (!cc.isEmpty()) {
            msg.addRecipients(Message.RecipientType.CC, cc);
        }
        if (!(bcc = mail.getBccAddress()).isEmpty()) {
            msg.addRecipients(Message.RecipientType.BCC, bcc);
        }
        msg.setSubject(MimeUtility.encodeText((String)mail.getSubject(), (String)"UTF-8", (String)"B"));
        MimeMultipart parts = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
        parts.addBodyPart((BodyPart)part);
        List<AttachBean> attachBeanList = mail.getAttachs();
        if (attachBeanList != null) {
            for (AttachBean attach : attachBeanList) {
                MimeBodyPart attachPart = new MimeBodyPart();
                attachPart.attachFile(attach.getFile());
                attachPart.setFileName(MimeUtility.encodeText((String)attach.getFileName()));
                String cid = attach.getCid();
                if (cid != null) {
                    attachPart.setContentID(cid);
                }
                parts.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)parts);
        final Semaphore semaphore = new Semaphore(1, true);
        final AtomicReference<String> status = new AtomicReference<String>(beginToSend);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            Transport transport = session.getTransport();
            transport.addTransportListener(new TransportListener(){

                public void messagePartiallyDelivered(TransportEvent e) {
                    log.info("======mail:{} messagePartiallyDelivered ====== ", (Object)mail.toString());
                    status.set(MailUtils.partiallyDelivered);
                    semaphore.release();
                }

                public void messageNotDelivered(TransportEvent e) {
                    log.info("======mail:{} messageNotDelivered ====== ", (Object)mail.toString());
                    status.set(MailUtils.notDelivered);
                    semaphore.release();
                }

                public void messageDelivered(TransportEvent e) {
                    log.info("======mail:{} messageDelivered ====== ", (Object)mail.toString());
                    status.set(MailUtils.delivered);
                    semaphore.release();
                }
            });
            transport.connect();
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            log.info("====send mail OK ===== in try catch ====");
        }
        catch (Exception e) {
            log.info("mail send failure : {} and will send directly ", (Throwable)e);
            Transport.send((Message)msg);
            status.set(notDelivered);
            semaphore.release();
        }
        try {
            log.info("begin to wait semaphore and send status :{} ", (Object)status.get());
            semaphore.acquire();
            if (status.equals(notDelivered)) {
                log.info("send mail:{} failure cause by : {} and will cache it for next time send ", (Object)mail.toString(), status);
            }
            log.info(" wait semaphore over ");
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        finally {
            semaphore.release();
        }
    }
}

