package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.draw.service.ActivityUserService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteResult;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteStatisticsService;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Feb 22, 2016 3:19:27 PM
 * @desc :
 */
@Service
@Slf4j
public class VoteStatisticsServiceImpl implements VoteStatisticsService {

    private static final int VOTE_ACTIVITY_CATEGORY = TemplateTypeCategory.VOTE_TYPE.getType();

    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private ActivityUserService activityUserService;
    @Autowired
    private VoteOptionDao voteOptionDao;

    /**
     * 统计一定时间内的访问人数信息
     */
    @Override
    public List<DairyCountStatistics> accessDairyCountStatistics(Long activityId, Long orgId, List<String> dateList) {

        boolean check = validateActivity(activityId, orgId);
        if (!check) {
            return Collections.emptyList();
        }
        List<DairyCountStatistics> retResults = new ArrayList<>();
        List<ActivityAccessLog> logs =
            this.activityAccessLogDao.selectActivityAccessLogByDate(dateList, activityId, VOTE_ACTIVITY_CATEGORY);
        if (GenericsUtils.isNullOrEmpty(logs)) {
            logs = new ArrayList<>();
        }
        /*
         * logMaps中是从ActivityAccessLog中提取的访问日期String，日期和相应的ActivityAccessLog 组成logMaps集合(2016年3月2日修改)
         */
        Map<String, ActivityAccessLog> logMaps =
            CollectionUtils.extractMap(logs, new CollectionUtils.Extracter<String, ActivityAccessLog>() {

                @Override
                public String extract(ActivityAccessLog arg0) {
                    return arg0.getAccessDate();
                }
            });

        Integer count = 0;
        for (String date : dateList) {
            DairyCountStatistics dcs = new DairyCountStatistics();
            ActivityAccessLog log = logMaps.get(date);
            if (log != null) {
                count = log.getAccessCount();
            }
            dcs.setCount(count);
            dcs.setDate(date);
            count = 0;
            retResults.add(dcs);
        }
        return retResults;
    }

    /**
     * 校验当前请求的活动与机构间的匹配性
     * 
     * @param activityId
     * @param orgId
     * @return
     */
    private boolean validateActivity(Long activityId, Long orgId) {
        VoteInfo voteInfo = voteInfoDao.selectVoteInfo(activityId, orgId);
        if (voteInfo == null) {
            log.info("can not find any activity with activityId:{} and orgId:{}", activityId, orgId);
            return false;
        }
        return true;
    }

    /**
     * 统计某个活动的参与人数信息
     */
    @Override
    public List<DairyCountStatistics> partakeDairyCountStatistics(Long activityId, Long orgId) {
        VoteInfo vi = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        Date startDate = vi.getStartTime();
        Date endDate = vi.getEndTime();
        List<DairyCountStatistics> dairyCountStatistics =
            this.activityUserService.getActivityUserStatistics(activityId, VOTE_ACTIVITY_CATEGORY, startDate, endDate);
        if (GenericsUtils.isNullOrEmpty(dairyCountStatistics)) {
            return Collections.emptyList();
        }
        return dairyCountStatistics;
    }

    /**
     * 统计某个活动的投票结果数据
     */
    @Override
    public List<VoteResult> votedDairyCountStatistics(Long activityId, Long orgId) {
        boolean isCheck = validateActivity(activityId, orgId);
        if (!isCheck) {
            return Collections.emptyList();
        }
        List<Long> activityIds = Arrays.asList(activityId);
        Map<Long, Map<Long, Integer>> statisticalVotes =
            this.activityUserDao.statisticalVotes(activityIds, VOTE_ACTIVITY_CATEGORY);
        if (GenericsUtils.isNullOrEmpty(statisticalVotes)) {
            return Collections.emptyList();
        }
        Map<Long, Integer> votedResults = statisticalVotes.get(activityId);
        Set<Long> optionsIds = new HashSet<>(votedResults.size());
        for (Map.Entry<Long, Integer> entry : votedResults.entrySet()) {
            optionsIds.add(entry.getKey());
        }
        List<VoteOption> voteOptions = this.voteOptionDao.selectVoteOptionsByVoteId(activityId);
        if (GenericsUtils.isNullOrEmpty(voteOptions)) {
            return Collections.emptyList();
        }
        Integer num = 1;
        List<VoteResult> retResults = new ArrayList<>();
        for (VoteOption voteOption : voteOptions) {
            Long optionsId = voteOption.getId();
            VoteResult vr = new VoteResult();
            Integer count = votedResults.get(optionsId);
            if (count == null) {
                count = 0;
            }
            vr.setNumber(num++);
            vr.setName(voteOption.getName());
            vr.setCount(count);
            retResults.add(vr);
        }
        return retResults;
    }

}
