/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteDataStatisticService;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月24日
 * @desc
 */
@Service
@Slf4j
public class VoteDataStatisticServiceImpl implements VoteDataStatisticService {
    @Autowired
    VoteInfoDao VoteInfoDao;
    @Autowired
    ActivityUserDao activityUserDao;
    @Autowired
    ActivityAccessLogDao activityAccessLogDao;

    @Override
    public Map<Long, VoteStatistics> getVoteData(Date startTime, Date endTime, String startDate, String curDate,
        List<Long> TianxiaoOrgIds, int way) {
        Map<Long, VoteStatistics> voteDatas = new HashMap<>();
        List<Long> orgIds = this.VoteInfoDao.getExistOrgIds(TianxiaoOrgIds);
        if (orgIds == null || orgIds.size() == 0) {
            return voteDatas;
        }
        Map<Long, List<Long>> allOrgIdActivityIdMap = VoteInfoDao.getVoteActivityIdsByOrgIds(orgIds, null, null);
        Map<Long, List<Long>> newOrgIdActivityIdMap =
            VoteInfoDao.getVoteActivityIdsByOrgIds(orgIds, startTime, endTime);

        for (Long orgId : orgIds) {
            VoteStatistics voteStatisticData = new VoteStatistics();
            Integer voteActivityTotal;
            if (GenericsUtils.isNullOrEmpty(newOrgIdActivityIdMap.get(orgId))) {
                voteActivityTotal = 0;
            } else {
                voteActivityTotal = newOrgIdActivityIdMap.get(orgId).size();
            }
            List<Long> activityIds = allOrgIdActivityIdMap.get(orgId);
            Integer browseCount = 0;
            if (way == 3) {
                browseCount = this.activityAccessLogDao.getActivityAccessLogTotal(activityIds,
                    TemplateTypeCategory.VOTE_TYPE.getType());
            } else {
                browseCount = this.activityAccessLogDao.getActivityAccessLogTotalByDay(activityIds,
                    TemplateTypeCategory.VOTE_TYPE.getType(), startDate, curDate);
            }
            log.info("orgid = " + orgId + "    投票访问人数===========" + browseCount);
            Integer voteCount = this.activityUserDao.getUserTotal(activityIds, TemplateTypeCategory.VOTE_TYPE.getType(),
                startTime, endTime);
            voteStatisticData.setVoteActivityTotal(voteActivityTotal == null ? 0 : voteActivityTotal);
            voteStatisticData.setBrowseCount(browseCount == null ? 0 : browseCount);
            voteStatisticData.setVoteCount(voteCount == null ? 0 : voteCount);

            voteDatas.put(orgId, voteStatisticData);
        }
        return voteDatas;
    }

}
