package com.baijia.tianxiao.sal.marketing.vote.service;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoResponse;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteListDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteRenderDto;

import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/2/20.
 */
public interface VoteService {

    public VoteInfoResponse modifyVoteInfo(VoteInfoRequest request, Long orgId);

    public void modifyVoteInfoStatus(Long voteId, Long orgId, int status);

    public VoteInfoResponse getVoteInfoById(long voteId, long orgId);

    public VoteRenderDto getVoteRenderDtoById(long voteId, String wechatOpenId);

    public List<VoteListDto> getVoteList(int status, long orgId, PageInfo pageInfo);

    /**
     * 统计投票结果
     * 
     * @param activityId
     * @param wechatOpenId
     * @param isVotedByDay
     * @return
     */
    public Map<Long, ActivityUser> getVoteResultByWechatOpenId(Long activityId, String wechatOpenId, int isVotedByDay);

    public void exportVoteDetail(long activityId);

}
