
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 17, 2016
 * @desc
 */
@Data
@Slf4j
public class SmsGroupSendRequest {

    public static final Integer NOT_ALL = 0; // 代表非全部学员或者非全部班级
    public static final Integer IS_ALL = 1; // 代表全部学员或者全部班级

    public static final String splitSymbol = SmsGroupSendListDto.splitSymbol;

    /**
     * if(stuStatus == 1){ <br/>
     * stuStatus = 所有取勾的用户ID <br/>
     * }else{ <br/>
     * stuStatus = 所有勾选的学员ID <br/>
     * } <br/>
     * 
     * if(courseStatus == 1){ <br/>
     * courseIds = 所有取勾的班级ID <br/>
     * }else{ <br/>
     * courseIds = 所有勾选的班级ID <br/>
     * } <br/>
     */

    private Long recordId; // 当前群发记录的ID(客户端非必填)
    private String studentIds; // 学员id 12,344,546
    private String courseIds; // course id 12,23,435,65
    private Integer studentStatus = 0; // 学员列表选择状态 0:非全部学员 1:全部学员
    private Integer courseStatus = 0; // 班级列表状态 0:非全部班级 1:全部班级
    private String content; // 当前客户端请求群发的短信内容(非必填)

    // ===============数据传递参数 BEGIN =============
    private Long orgId;
    private Long cascadeId;
    private PageDto pageDto;
    private List<Long> studentIdList = Lists.newArrayList();
    private List<Long> courseIdList = Lists.newArrayList();
    // 业务代码参数传递属性
    private boolean needDistinct;
    // ===============数据传递参数 END =============

    public void setStudentIds(String studentIds) {
        this.studentIds = studentIds;
        if (GenericsUtils.notNullAndEmpty(studentIds)) {
            this.studentIdList.addAll(getIdsFromString(studentIds));
        }
    }

    public void setCourseIds(String courseIds) {
        this.courseIds = courseIds;
        if (GenericsUtils.notNullAndEmpty(courseIds)) {
            this.courseIdList.addAll(getIdsFromString(courseIds));
        }
    }

    /**
     * @param studentIds2
     * @return
     */
    private List<Long> getIdsFromString(String idsStr) {
        log.debug("idStr is : {} ", idsStr);
        String[] ids = idsStr.split(",");
        List<Long> idList = Lists.newArrayListWithCapacity(ids.length);
        for (String idStr : ids) {
            try {
                idList.add(Long.parseLong(idStr));
            } catch (NumberFormatException e) {
                log.debug("error whhile parseLong from str: {} ", idStr);
            }
        }
        return idList;
    }

    public boolean isAllStudent() {
        return this.studentStatus == NOT_ALL ? false : true;
    }

    public boolean isAllCourse() {
        return this.courseStatus == NOT_ALL ? false : true;
    }

    public void checkParams() {
        if ((GenericsUtils.isNullOrEmpty(studentIdList) && !this.isAllStudent())
            && (GenericsUtils.isNullOrEmpty(courseIdList) && !this.isAllCourse())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "未选定任何学员");
        }
    }

    /**
     * @param studentDtos
     * @return
     */
    public SmsGroupSendRecord buildPo(List<StudentDto> studentDtos) {
        if (GenericsUtils.isNullOrEmpty(studentDtos)) {
            return null;
        }
        Timestamp nowTimestamp = new Timestamp(new Date().getTime());
        SmsGroupSendRecord record = new SmsGroupSendRecord();
        record.setOrgId(orgId);
        record.setContent(this.content);
        record.setId(this.recordId);
        record.setCreateCascadeId(this.cascadeId);
        record.setCreateTime(nowTimestamp);
        record.setUpdateTime(nowTimestamp);
        record.setSendStatus(SendStatus.WAIT_TO_SEND.code);
        String allReceivers = extractReceivers(studentDtos);
        record.setAllReceiver(allReceivers);
        record.setTotalCount(studentDtos.size());
        return record;
    }

    /**
     * 获取所有学员的ID拼凑:123,345,2354 用于DB存储
     * 
     * @param studentDtos
     * @return
     */
    public static String extractReceivers(List<StudentDto> studentDtos) {
        StringBuilder sb = new StringBuilder();
        for (StudentDto sd : studentDtos) {
            sb.append(sd.getId()).append(",");
        }
        String allReceivers = GenericsUtils.deleteLastCharToString(sb);
        return allReceivers;
    }

    /**
     * 获取所有学员的姓名拼凑:张三、李四、王五、...用于前端数据展示
     * 
     * @param studentDtos
     * @return
     */
    public static String extractReceiverNames(List<StudentDto> studentDtos) {
        StringBuilder sb = new StringBuilder();
        for (StudentDto sd : studentDtos) {
            sb.append(sd.getName()).append(splitSymbol);
        }
        String allReceivers = GenericsUtils.deleteLastCharToString(sb);
        return allReceivers;
    }

}
