/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.export.dto;

import com.baijia.tianxiao.dal.export.po.TXStatisticData;

import org.springframework.beans.BeanUtils;

import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年4月18日
 * @desc
 */
@Data
public class ExportDto {
    private String orgShortName = "";
    private Integer orgNumber = 0;
    private String areId; //机构所在地
    private int internalSign;    //是否是内部机构
    private String orgVipLevelStr;  //机构身份类型 可以查看TXAccountType  专业版 企业版 定制版 大众版 。。。
    
    private boolean isHasSubCompus;    //是否有总分校区
    private String compusTypeDesc = "";     //总份校区描述
    private int subOrgNumber;  //子校区机构的主校区orgNumber
    
    public void setIsHasSubCompus(Boolean isHasSubCompus){
        this.isHasSubCompus = isHasSubCompus;
    }
    
    public Boolean getIsHasSubCompus(){
        return this.isHasSubCompus;
    }
    
    private int accountType;     
    private String accountTypeDesc = "";     //机构类型描述

    private int backlogTotal;
    private int backlogFinish;
    private int backlogExpire;

    private int clueTotal;
    private int clueWechat;
    private int clueReserve; // 预约留单
    private int clueCall; // 400电话新增
    
    private int commentStudentSystemTotal; //跟进记录学生系统添加总数
    private int commentStudentNotSystemTotal; //跟进记录学生手动添加总数
    private int commentConsultSystemTotal; //跟进记录系统意向学员系统添加
    private int commentConsultNotSystemTotal; //跟进记录意向学员手动添加

    private int consultUserTotal; // 意向学员

    private int incrementStudentTotal;  //学员增量
    private int studentTotal; // 学员
    private int studyStudentTotal;  //在读学员总数

    private boolean isWechatAuthorizer; // 是否有微信公众号
    private boolean isWechatMenu; // 是否有公众号菜单
    private String serviceTypeDesc = "";      //微信公众号类型描述
    private int wechatFansTotal; /// 粉丝数

    public void setIsWechatAuthorizer(boolean isWechatAuthorizer) {
        this.isWechatAuthorizer = isWechatAuthorizer;
    }

    public boolean getIsWechatAuthorizer() {
        return isWechatAuthorizer;
    }

    public void setIsWechatMenu(boolean isWechatMenu) {
        this.isWechatMenu = isWechatMenu;
    }

    public boolean getIsWechatMenu() {
        return isWechatMenu;
    }

    private int courseTotal; // 微课数

    private int arrangedClassTotal; // 排课数
    private int lessonTotal; // 课节数

    private int courseSmsTotal; // 课表数

    private double incomeSum; // 收入总额
    private int incomeTotal; // 收入笔数

    private int signLessonTotal; // 签到课节数
    private int signStudentTotal; // 签到学生数

    private double cashPurchaseSum; // 提现

    private int commentByStudent; // 学生评价
    private int commentByTeacher; // 老师评价

    private int teacherTotal; // 老师数
    private int roomTotal; // 教室数

    private int activityTotal; // 发活动数
    private int activityAccessTotal; // 发活动访问量
    private int activityEnrollTotal; // 发活动报名数

    private int drawActivityTotal; // 抽奖活动数
    private int drawUserTotal; // 抽奖活动参与数
    private int drawWinnerTotal; // 抽奖中奖人数

    private int voteActivityTotal; // 投票活动数
    private int voteAccessTotal; // 投票活动参与人数
    private int voteTotal; // 投票数

    private int referralActivityTotal; // 转介绍活动数
    private int referralAccessTotal; // 转介绍访问人数
    private int brokerTotal; // 转介绍经纪人数
    private int referralTotal; // 转介绍人数

    private int groupMsgTotal; // 群发消息数
    private int msgReceiverTotal; // 群发消息接受人数

    private boolean isUseHomePage; // 是否使用主页模板

    public void setIsUseHomePage(boolean isUseHomePage) {
        this.isUseHomePage = isUseHomePage;
    }

    public boolean getIsUseHomePage() {
        return isUseHomePage;
    }

    private int uvTotal; // UV使用量
    private int pvTotal; // PV使用量

    private int loginTotal; // 机构登录次数

    private int wechatAuthorizerOfStudentTotal; // 绑定微信公众号学生数

    private int smsTotal; // 短信数
    
    //400电话
    private int orgCallRecordCount;    //400通话次数
    private int orgCallRecordTime;     //400电话通话时长
    
    //双呼
    private int callServiceCount;    //双呼通话次数
    private int callServiceDuration;    //双呼通话时长
    
    private String startDate = "";    //插入数据时间范围开始时间
    private String curDate = "";      //插入数据时间结束时间
    
    private int signTeacherTotal;
    
    private int loginAccountTotal;
    private int loginDeviceTotal;
    
    private int orgOpenTotal;   //设备打开次数
    
    
    public static TXStatisticData buildTXStatisticDataByExportDto(ExportDto exportDto, int way){
        TXStatisticData txStatisticData = new TXStatisticData();
        BeanUtils.copyProperties(exportDto, txStatisticData, "isWechatAuthorizer", "isWechatMenu", "isUseHomePage");
        txStatisticData.setIsWechatAuthorizer(exportDto.getIsWechatAuthorizer() == true ? 1 : 0);
        txStatisticData.setIsWechatMenu(exportDto.getIsWechatMenu() == true ? 1 : 0);
        txStatisticData.setIsUseHomePage(exportDto.getIsUseHomePage() == true ? 1 : 0);
        Date updateTime = new Date();
        txStatisticData.setWay(way);
        txStatisticData.setUpdateTime(updateTime);
        return txStatisticData;
    }
    
}
