package com.baijia.tianxiao.sal.marketing.commons.enums;

import com.baijia.tianxiao.util.properties.PropertiesReader;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author Rezar
 * @createDate :Jan 14, 2016 3:18:45 PM
 * @desc :
 */

public enum ConstantEnums {

    MAILBOX_SMTPSERVIER, ACTIVITY_H5_URL, MAILBOX_USERNAME, MAILBOX_PASSWORD, MAILBOX_FROM, MAILBOX_CONTENT, MAILBOX_SUBJECT, MAP_API_URL, EMAIL_COUNT_LIMIT, MAILBOX_RRAW_SUBJECT_PARTAKE, MAILBOX_DRAW_CONTENT_PARTAKE, MAILBOX_RRAW_SUBJECT_VISIT, MAILBOX_DRAW_CONTENT_VISIT, MAILBOX_DRAW_SUBJECT_WINNER, MAILBOX_DRAW_CONTENT_WINNER, DRAW_DEFAULT_TEMPLATE,
    // 投票活动的分享文案
    VOTE_SLOGAN,
    // 投票活动的主题
    MAILBOX_VOTE_SUBJECT_RESULT,
    // 投票活动的邮件内容
    MAILBOX_VOTE_CONTENT_RESULT,
    // 投票活动微信公众号分享的头图url
    VOTE_TOP_IMG_URL,
    // 转介绍活动微信公众号分享的头图url
    REFERRAL_WECHAT_IMG_URL,
    // 转介绍活动默认头图
    REFERRAL_TOP_PIC_URL,
    // 转介绍每人每天可以推荐的人数上限
    REFERRAL_INTRODUCE_LIMIT,
    // 转介绍活动默认的头图
    REFERRAL_DEFAULT_TOP_PIC,
    // 转介绍活动的分享文案
    REFERRAL_SLOGAN,
    // 机构主页url
    ORG_HOME_PAGE_URL,
    // 经纪人邮件导出主题
    // REFERRAL_BROKERS_SUBJECT,
    
    //微官网连接
    ORG_WEI_PAGE,
    //天校数据邮件寄件人相关信息
    TIANXIAO_MAILBOX_SMTPSERVIER,
    TIANXIAO_MAILBOX_USERNAME,
    TIANXIAO_MAILBOX_PASSWORD,
    TIANXIAO_MAILBOX_FROM,
    
    //咨询白金版邮件接收人
    MAILBOX_CONTACTS_CONSULT_VERSION,
    ;

    public static final String ACTIVITY_PROPERTY_FILE = "activity.properties";

    private Map<String, String> keyValueMapper = new HashMap<>();
    private boolean hasInit;

    public String value() {
        initName();
        String name = this.name();
        name = name.replace("_", ".");
        if (this.keyValueMapper.containsKey(name)) {
            return this.keyValueMapper.get(name);
        } else {
            throw new IllegalArgumentException(
                "the property whose  name : " + name + " is not exists in properties file : " + ACTIVITY_PROPERTY_FILE);
        }
    }

    private void initName() {
        if (!hasInit) {
            synchronized (keyValueMapper) {
                if (!hasInit) {
                    Properties properties = PropertiesReader.getProperties(ACTIVITY_PROPERTY_FILE);
                    if (properties != null) {
                        Enumeration<?> propertyNames = properties.propertyNames();
                        while (propertyNames.hasMoreElements()) {
                            Object keyObj = propertyNames.nextElement();
                            String key = String.valueOf(keyObj);
                            keyValueMapper.put(key, properties.getProperty(key));
                        }
                    }
                    hasInit = true;
                }
            }
        }
    }

    public static String findProperties(String key) {
        return PropertiesReader.getProperties(ACTIVITY_PROPERTY_FILE).getProperty(key);
    }
}
