package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonToMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Created by liuxp on 16/1/12.
 */
public class ActivityEnrollDto {
    private long enrollId;
    private String mobile;
    private String name;
    private long createTime;
    private Object content;

    public long getEnrollId() {
        return enrollId;
    }

    public void setEnrollId(long enrollId) {
        this.enrollId = enrollId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public Object getContent() {
        return content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public static ActivityEnrollDto getInstance(ActivityEnroll enroll) {
        ActivityEnrollDto dto = new ActivityEnrollDto();
        dto.setEnrollId(enroll.getId());
        dto.setCreateTime(enroll.getCreateTime().getTime());
        Map<String, Object> map = JsonToMap.toMap(enroll.getContent());
        dto.setName((String) map.get("name"));
        dto.setMobile((String) map.get("mobile"));
        map.remove("name");
        map.remove("mobile");
        dto.setContent(getMapValue(map));
        return dto;
    }

    private static String getMapValue(Map<String,Object> map){
        Set<String> keySet = map.keySet();
        StringBuilder sb = new StringBuilder();
        for(Iterator<String> iter = keySet.iterator();iter.hasNext();){
            sb.append(",").append(map.get(iter.next()));
        }
        if(sb.length()>0){
            return sb.substring(1);
        }else {
            return "";
        }
    }

    public static void main(String[] args) {
        ActivityEnroll enroll = new ActivityEnroll();
        enroll.setId(100L);
        enroll.setCreateTime(new Timestamp(new Date().getTime()));
        enroll.setContent("{\"name\":\"lxp\",\"mobile\":\"15499900000\",\"field0\":\"hhahahah\"}");

        System.out.println(ToStringBuilder.reflectionToString(getInstance(enroll)));
    }
}
