package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;
import com.baijia.tianxiao.sal.marketing.referral.enums.AccountType;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

/**
 * Created by liuxp on 16/3/4.
 *
 * 佣金数据对象
 */
@Data
public class CommissionDto {
    private long activityId;
    private String brokerName;// 经纪人姓名
    private String brokerPhone;// 经纪人电话
    private String accountType;// 账户类型
    private String accountNum="0";// 账号
    private String amount;// 佣金总额，如果没有现金，只有非现金，返回“实物礼品”
    private Long settleTime;// 佣金结算时间戳
    private Long lastMarkTime;// 佣金结算时间戳

    private Integer giftType = 2; // 2:非现金 1:现金礼物

    public static CommissionDto getInstanceFromRecord(ReferralRecord record) {
        CommissionDto dto = new CommissionDto();
        dto.setActivityId(record.getActivityId());
        dto.setBrokerName(record.getBrokerName());
        dto.setBrokerPhone(record.getBrokerPhone());
        if(StringUtils.isNotBlank(record.getAccountNum())) {
            dto.setAccountNum(record.getAccountNum());
        }
        dto.setAmount(record.getGiftDesc());
        dto.setLastMarkTime(record.getMarkTime().getTime());
        if (record.getType() == 1) {
            dto.setGiftType(1);
        }
        dto.setAccountType(AccountType.ZHI_FU_BAO.getName());
        if (record.getSettlementStatus() == 1) {
            dto.setSettleTime(record.getUpdateTime().getTime());
        }
        return dto;
    }
}
