package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;

import lombok.Data;

/**
 * Created by liuxp on 16/3/4.
 */
@Data
public class CommissionDetail {
    private long id;
    private String referralName;
    private String referralPhone;
    private long introduceTime;
    private long markTime;
    private GiftInfo gift;

    public static CommissionDetail buildDto(ReferralRecord rr, GiftInfo giftInfo) {
        CommissionDetail cd = new CommissionDetail();
        cd.setId(rr.getId());
        cd.setIntroduceTime(rr.getCreateTime().getTime());
        cd.setMarkTime(rr.getMarkTime().getTime());
        cd.setReferralName(rr.getReferralName());
        cd.setReferralPhone(rr.getReferralPhone());
        cd.setGift(giftInfo);
        return cd;
    }
}