package com.baijia.tianxiao.sal.marketing.commons.service;

import org.springframework.data.redis.core.RedisTemplate;

import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;

/**
 * Created by liuxp on 16/1/20.
 */
public interface RedisService {
    public boolean addOrgEmailCount(final long orgId, final long activityId, final int templateTypeId,
        EmailType emailType);

    public void setDrawActivityBase(final long activityId, final DrawCacheDto cacheDto);

    public DrawCacheDto getDrawActivityBase(long activityId);

    public VoteCacheDto getVoteActivityBase(Long activityId);

    void setVoteActivityBase(long activityId, VoteCacheDto cacheDto);

    Integer visitCount(String wechatOpenId, Long orgId);

    void setVisitCount(String wechatOpenId, Long orgId, Integer count);

    public void clearField(String key, String field);

    public void setchangeActivityStatus(Long activityId, Integer activityType, Integer status);

    public Integer getActivityStatus(final Long activityId, final Integer activityType);

    public RedisTemplate<String, String> getRedisTemplate();

    /**
     * @param key
     * @param valueObj
     * @return
     */
    Boolean setNXKey(String key, Object valueObj);

    /**
     * @param key
     * @return
     */

    <T> T getKeyValue(String key);

    /**
     * @param key
     * @param valueObj
     */
        
    void setKey(String key, Object valueObj);

    /**
     * @param orgId
     * @param activityId
     * @param templateTypeId
     * @param emailType
     * @return
     */
    boolean decreaseEmailCountWhileError(long orgId, long activityId, int templateTypeId, EmailType emailType);
}
