package com.baijia.tianxiao.sal.marketing.commons.enums;

import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/25.
 */
public enum  TemplateTypeCategory {
    COMMON_TYPE(1,"活动报名", CommonConstant.ACTIVITY_TYPE_ID, TXPermissionConst.HUODONGBAOMING.getPCode()),
    DRAW_TYPE(2,"微信抽奖", CommonConstant.DRAW_ACTIVITY_TYPE_ID, TXPermissionConst.CHOUJIANG.getPCode()),
    VOTE_TYPE(3,"微信投票", CommonConstant.VOTE_ACTIVITY_TYPE_ID, TXPermissionConst.TOUPIAO.getPCode()),
    REFERRAL_TYPE(4,"转介绍", CommonConstant.REFERRAL_ACTIVITY_TYPE_ID, TXPermissionConst.ZHUANJIESHAO.getPCode());  //gandan 添加转介绍活动

    private int type;
    private String label;
    private int typeId;
    private long pCode;  //营销入口权限码
    
    private static Map<Integer, TemplateTypeCategory> templateTypeMap = new HashMap<>();
    private static Map<Integer, TemplateTypeCategory> templateIdMap = new HashMap<>();
    
    static{
        for(TemplateTypeCategory category : TemplateTypeCategory.values()){
            templateTypeMap.put(category.getType(), category);
            templateIdMap.put(category.getTypeId(), category);
        }
    }
    
    public static TemplateTypeCategory getTemplateTypeCategoryByType(Integer type){
        return templateTypeMap.get(type);
    }
    
    public static TemplateTypeCategory getTemplateTypeCategoryByTypeId(Integer typeId){
        return templateIdMap.get(typeId);
    }

    private TemplateTypeCategory(int type, String label, int typeId, long pCode) {
        this.type = type;
        this.label = label;
        this.typeId = typeId;
        this.pCode = pCode;
    }
    
    public long getPCode(){
        return pCode;
    }
    
    public int getType() {
        return type;
    }

    public String getLabel() {
        return label;
    }
    
    public int getTypeId(){
        return this.typeId;
    }
    
    public static List<Integer> getTypeIdList(){
        List<Integer> typeIds = new ArrayList<>();
        typeIds.add(COMMON_TYPE.getTypeId());
        typeIds.add(DRAW_TYPE.getTypeId());
        typeIds.add(VOTE_TYPE.getTypeId());
        typeIds.add(REFERRAL_TYPE.getTypeId());
        return typeIds;
    }
}
