package com.baijia.tianxiao.sal.marketing.commons.dtos;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonToMap;
import lombok.Data;

import java.util.Map;

/**
 * Created by liuxp on 16/2/26.
 */
@Data
public class MnsEnrollDto implements MnsDto{
    private String userName;//报名填写的姓名
    private String mobile;//报名手机号码
    private long id;
    private String name;//活动名称
    private long createTime;
    private long orgId;

    public static MnsEnrollDto getInstance(Activity activity,ActivityEnroll enroll){
        MnsEnrollDto dto = new MnsEnrollDto();
        dto.setId(activity.getId());
        dto.setName(activity.getTitle());
        dto.setCreateTime(enroll.getCreateTime().getTime());
        dto.setOrgId(activity.getOrgId().longValue());
        Map<String, Object> map = JsonToMap.toMap(enroll.getContent());
        dto.setUserName((String) map.get("name"));
        dto.setMobile((String) map.get("mobile"));
        return dto;
    }
}
