/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.sal.marketing.article.utils.ArticleUtil;
import com.baijia.tianxiao.sal.marketing.article.utils.QrCodeUtil;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;

import java.sql.Timestamp;
import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年3月17日
 * @desc
 */
@Data
public class ArticleDetailDto extends ArticleBaseDto {
    private int source;
    private String content;
    private String author;
    private String translator;
    private Timestamp publicTime;
    private String digest;// 摘要

    private String originUrl;
    private String orgLogo;
    private String orgName;
    private String orgQrCodeUrl;
    private String orgHomeUrl;
    private String orgWeiPage;
    private String orgHomeQrCodeUrl;

    // 获取ArticleDetailDto实例
    // TODO 发布时间和来源
    public static ArticleDetailDto buildDto(ArticleDetail detail) {
        ArticleDetailDto articleDto = new ArticleDetailDto();
        articleDto.setTitle(detail.getArticleTitle());
        articleDto.setSource(1);
        articleDto.setOriginUrl(detail.getArticleUrl());
        articleDto.setThumbNail(detail.getArticleImg());
        articleDto.setArticleId(detail.getId());
        articleDto.setContent(QrCodeUtil.replaceWechatImgUrl(detail.getContent()));
        articleDto.setPublicTime(new Timestamp(new Date().getTime()));
        articleDto.setDigest(ArticleUtil.getDigest(detail.getContent()));
        return articleDto;
    }

    public void setOrgInfo(OrgInfoSimpleDto orgInfo) {
        this.orgLogo = orgInfo.getLogo();
        this.orgName = orgInfo.getShortName(); // 获取机构的名称
    }
}
