package com.baijia.tianxiao.sal.marketing.activity.service;

import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityBaseInfo;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySearchRequest;

import java.util.List;

/**
 * @author Rezar
 * @createDate :Jan 10, 2016 10:43:46 PM
 * @desc : 活动service
 */
public interface ActivityService {

    /**
     * 进行活动的保存
     * @param request
     * @param orgId
     * @return
     */
    public ActivityDetailDto saveOrgActivity(ActivitySearchRequest request, Integer orgId);

    /**
     * 对指定机构的指定活动进行删除
     * @param searchRequest
     */
    public void deleteActivity(ActivitySearchRequest searchRequest);

    /**
     * 根据指定活动的id 进行活动查询
     * @param searchRequest
     * @return
     */
    public ActivityDetailDto getActivityDetail(ActivitySearchRequest searchRequest);

    /**
     * 对指定活动进行更新操作
     * @param request
     * @return
     */
    public ActivityDetailDto update(ActivitySearchRequest request);

    /**
     * 获取活动基本信息列表
     * 
     * @return
     */
    public List<ActivityBaseInfo> getActivitiesByOrgId(ActivitySearchRequest searchRequest);

    /**
     * 浏览活动+1
     * 
     * @param activityId
     */
    public void incrBrowseCount(Long activityId, Long orgId);
}
