package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.dal.activity.po.Template;

import org.springframework.beans.BeanUtils;

/**
 * Created by liuxp on 16/1/9.
 */
public class TemplateDto {
    private int templateId;//模板id
    private int typeId;//归属的类型id
    private String name;//模板名称
    private String desc;//模板描述信息
    private String thumbNail;//缩略图url
    private String initial;//首字母
    private int amountOfUsage;//使用量
    private String url;//模板访问url
    private Integer templateType; // 1：在线报名，2：抽奖，3：投票，4转介绍
    
    private Integer hasPermition;  //模板是否有访问权限 0：没有， 1：有
    private Integer vipLevel; //机构版本类型 5:免费版，6：白金版
    private String promotionIconUrl;  //模板促销url
    
    
    private String title;   //模板标题：[活动报名]:蓝色卡通
    
    public String getPromotionIconUrl(){
        return promotionIconUrl;
    }
    
    public void setPromotionIconUrl(String promotionIconUrl){
        this.promotionIconUrl = promotionIconUrl;
    }
    
    public Integer getVipLevel(){
        return this.vipLevel;
    }
    public void setVipLevel(Integer vipLevel){
        this.vipLevel = vipLevel;
    }
    
    public Integer getHasPermition(){
        return this.hasPermition;
    }
    
    public void setHasPermition(Integer hasPermition){
        this.hasPermition = hasPermition;
    }
    
    public void setTemplateType(Integer templateType){
        this.templateType = templateType;
    }
    
    public Integer getTemplateType(){
        return this.templateType;
    }
    
    public void setTitle(String title){
        this.title = title;
    }
    
    public String getTitle(){
        return this.title;
    }
    
    public int getTemplateId() {
        return templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public int getTypeId() {
        return typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getThumbNail() {
        return thumbNail;
    }

    public void setThumbNail(String thumbNail) {
        this.thumbNail = thumbNail;
    }

    public String getInitial() {
        return initial;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    public int getAmountOfUsage() {
        return amountOfUsage;
    }

    public void setAmountOfUsage(int amountOfUsage) {
        this.amountOfUsage = amountOfUsage;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static TemplateDto getInstance(Template template){
        TemplateDto dto = new TemplateDto();
        BeanUtils.copyProperties(template,dto);
        dto.setTemplateId(template.getTemplateId());
        return dto;
    }
}
