/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.vote.utils;

import com.baijia.tianxiao.util.GenericsUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static File getTemplateFile(String fileName) {
        if (GenericsUtils.isNullOrEmpty((Object)fileName)) {
            fileName = System.currentTimeMillis() + "_" + Math.random() * 1000000.0 + ".file";
        }
        String property = System.getProperty("java.io.tmpdir");
        File file = new File(property);
        File newFile = new File(file, fileName);
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("{# error while create a new file cause by : {} #}", (Throwable)e);
        }
        return newFile;
    }

    public static File[] listFileByPath(String classFilePath, FileFilter fileFilter) {
        URL url = FileUtils.getFileUrl(classFilePath);
        String fileDir = url.getFile();
        System.out.println(fileDir);
        File f = new File(fileDir);
        File[] files = f.listFiles(fileFilter);
        return files;
    }

    public static URL getFileUrl(String classFilePath) {
        URL url = FileUtils.class.getResource(classFilePath);
        return url;
    }

    public static File getFile(String classFilePath) {
        URL url = FileUtils.getFileUrl(classFilePath);
        if (url != null) {
            String filePath = url.getFile();
            return new File(filePath);
        }
        return null;
    }
}

