/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.enums;

import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TemplateTypeCategory {
    COMMON_TYPE(1, "\u6d3b\u52a8\u62a5\u540d", 3, TXPermissionConst.HUODONGBAOMING.getPCode()),
    DRAW_TYPE(2, "\u5fae\u4fe1\u62bd\u5956", 99, TXPermissionConst.CHOUJIANG.getPCode()),
    VOTE_TYPE(3, "\u5fae\u4fe1\u6295\u7968", 201, TXPermissionConst.TOUPIAO.getPCode()),
    REFERRAL_TYPE(4, "\u8f6c\u4ecb\u7ecd", 301, TXPermissionConst.ZHUANJIESHAO.getPCode());

    private int type;
    private String label;
    private int typeId;
    private long pCode;
    private static Map<Integer, TemplateTypeCategory> templateTypeMap;
    private static Map<Integer, TemplateTypeCategory> templateIdMap;

    public static TemplateTypeCategory getTemplateTypeCategoryByType(Integer type) {
        return templateTypeMap.get(type);
    }

    public static TemplateTypeCategory getTemplateTypeCategoryByTypeId(Integer typeId) {
        return templateIdMap.get(typeId);
    }

    private TemplateTypeCategory(int type, String label, int typeId, long pCode) {
        this.type = type;
        this.label = label;
        this.typeId = typeId;
        this.pCode = pCode;
    }

    public long getPCode() {
        return this.pCode;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public static List<Integer> getTypeIdList() {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        typeIds.add(COMMON_TYPE.getTypeId());
        typeIds.add(DRAW_TYPE.getTypeId());
        typeIds.add(VOTE_TYPE.getTypeId());
        typeIds.add(REFERRAL_TYPE.getTypeId());
        return typeIds;
    }

    static {
        templateTypeMap = new HashMap<Integer, TemplateTypeCategory>();
        templateIdMap = new HashMap<Integer, TemplateTypeCategory>();
        for (TemplateTypeCategory category : TemplateTypeCategory.values()) {
            templateTypeMap.put(category.getType(), category);
            templateIdMap.put(category.getTypeId(), category);
        }
    }
}

