package com.baijia.tianxiao.sal.marketing.vote.dto;

import java.sql.Timestamp;

import org.springframework.beans.BeanUtils;

import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * Created by liuxp on 16/2/22.
 */
@Data
public class VoteInfoRequest extends VoteInfoDto {
    private String voteOptions;

    @JsonIgnore
    private Long orgId;
    @JsonIgnore
    private String email;
    @JsonIgnore
    private Integer replaceOrgId;


    public VoteInfo getVoteInfo() {
        VoteInfo info = new VoteInfo();
        BeanUtils.copyProperties(this, info, "startTime", "endTime");
        if (this.getStartTime() != null && this.getStartTime() > 0) {
            info.setStartTime(new Timestamp(this.getStartTime()));
        }
        if (this.getEndTime() != null && this.getEndTime() > 0) {
            info.setEndTime(new Timestamp(this.getEndTime()));
        }
        return info;
    }
}
