package com.baijia.tianxiao.sal.marketing.draw.dto;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Date;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;

import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.sal.marketing.draw.enums.DrawStatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 11:15:11 AM
 * @desc : 抽奖活动基本信息对象
 */
public class DrawActivityBase {

    private Long activityId; // 活动的activityID
    @JsonIgnore
    private Long orgId; // 注意，这个值不建议返回的时候返回到前端

    private String name; // 当前活动的主题
    private Long startTime; // 当前活动开始时间戳
    private Long endTime; // 当前活动结束的时间戳
    private Long updateTime;// 当前活动的更新时间戳
    private Long createTime;
    private Integer countLimit; // 当前抽奖活动 ， 每个微信号每天可以参与的次数
    private String introduction; // 当前抽奖活动的简介
    private String content; // 当前活动的详细介绍
    private Integer startStatus; // 1,//1：未开始，2：进行中，3：已结束 ，后台进行校验，避免前端时间系统不一致导致的问题
    private Integer status;// 当前活动的状态
    private Integer infoFillStatus; // 1.是否需要关注微信公众号 2.是否需要填写手机号码信息 3.两者都需要
    private Integer delStatus = 0;// 活动的删除状态， 这么多状态，应该要统一起来

    private Integer browseCount; // 当前抽奖活动的浏览人数
    private Integer userCount; // 当前抽奖活动的参与人数
    private Integer winnerCount; // 当前抽奖活动的中奖人数
    private Integer remainCount; // 剩余抽奖次数

    private String url; // 对应的h5页面的url

    public DrawActivityBase buildDto(DrawInfo drawInfo) {
        try {
            BeanUtils.copyProperties(this, drawInfo);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    public DrawInfo buildPo() {
        SqlTimestampConverter converter = new SqlTimestampConverter();
        converter.setPattern("yyyy-MM-dd HH:mm:ss");
        ConvertUtils.register(converter, Timestamp.class);
        DrawInfo drawActivityInfo = new DrawInfo();
        try {
            BeanUtils.copyProperties(drawActivityInfo, this);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return drawActivityInfo;
    }

    public Integer getDelStatus() {
        return delStatus;
    }

    public void setDelStatus(Integer delStatus) {
        this.delStatus = delStatus;
    }

    public String getUrl() {
        return url;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getBrowseCount() {
        return browseCount;
    }

    public void setBrowseCount(Integer browseCount) {
        this.browseCount = browseCount;
    }

    public Integer getUserCount() {
        return userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public Integer getWinnerCount() {
        return winnerCount;
    }

    public void setWinnerCount(Integer winnerCount) {
        this.winnerCount = winnerCount;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 根据抽奖活动的相关时间确定开抽奖活动的状态
     * 
     * @return
     */
    public Integer getStartStatus() {
        Date date = new Date();
        if (this.endTime < date.getTime()) {
            this.startStatus = DrawStatusEnum.IS_END.code;
        } else if (this.startTime <= date.getTime()) {
            this.startStatus = DrawStatusEnum.RUNNING.code;
        } else {
            this.startStatus = DrawStatusEnum.NOT_START.code;
        }
        return startStatus;
    }

    public void setStartStatus(Integer startStatus) {
        this.startStatus = startStatus;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getRemainCount() {
        return remainCount;
    }

    public void setRemainCount(Integer remainCount) {
        this.remainCount = remainCount;
    }

    public Integer getInfoFillStatus() {
        return this.infoFillStatus;
    }

    public void setInfoFillStatus(Integer infoFillStatus) {
        this.infoFillStatus = infoFillStatus;
    }

    @Override
    public String toString() {
        return "DrawActivityBase [activityId=" + activityId + ", orgId=" + orgId + ", name=" + name + ", startTime="
            + startTime + ", endTime=" + endTime + ", updateTime=" + updateTime + ", countLimit=" + countLimit
            + ", introduction=" + introduction + ", content=" + content + ", startStatus=" + startStatus + ", status="
            + status + ", browseCount=" + browseCount + ", userCount=" + userCount + ", winnerCount=" + winnerCount
            + ", url=" + url + "]";
    }

}
