package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.sal.marketing.activity.dto.TemplateTypeDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.TemplateTypeService;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * Created by liuxp on 16/1/8.
 */
@Service
public class TemplateTypeServiceImpl implements TemplateTypeService {

    @Autowired
    private TemplateTypeDao templateTypeDao;

    @Override
    public List<TemplateTypeDto> getTypesByCategory(TemplateTypeCategory category) {
        List<TemplateType> types = templateTypeDao.selectTemplateTypeListByCategory(category.getType());
        types.add(0,TemplateType.ALL_TYPE);

        Collections.sort(types,new Comparator<TemplateType>() {
            @Override
            public int compare(TemplateType o1, TemplateType o2) {
                return o1.getSorted() - o2.getSorted();
            }
        });

        List<TemplateTypeDto> dtos = new ArrayList<>();

        for(TemplateType type:types){
            dtos.add(TemplateTypeDto.getInstance(type));
        }

        return dtos;
    }
}
