package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.MarketingEntryDao;
import com.baijia.tianxiao.dal.activity.po.MarketingEntry;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MarketingEntryDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.MarketingEntryEnventEnum;
import com.baijia.tianxiao.sal.marketing.commons.service.MarketingEntryService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/4/20.
 */
@Service
@Slf4j
public class MarketingEntryServiceImpl implements MarketingEntryService {

    @Autowired
    private MarketingEntryDao entryDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public List<MarketingEntryDto> getAllMarketingEntry(boolean hasSmartPromote, String version, Integer orgId,
        Integer cascadeId) {
        List<MarketingEntryDto> dtoList = new ArrayList<>();
        final List<MarketingEntry> entries = entryDao.selectAllMarketingEntries();
        Map<Integer, MarketingEntryDto> entryMap = new LinkedHashMap<>();

        TxAccountPermissionsDto permissions = null;
        try {
            permissions = permissionService.universalGetPermissions(orgId, cascadeId);
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.PERMISSION_DENY);
        }
        Map<Long, Integer> map = new HashMap<>();
        if (permissions != null && permissions.getAPPps() != null && permissions.getAPPps().size() > 0) {
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto : permissions.getAPPps()) {
                map.put(permissionDto.getPCode(), permissionDto.getPType());
            }
        }

        log.info("[MarketingEntry] permissions={}", map);

        Collections.sort(entries, new Comparator<MarketingEntry>() {
            @Override
            public int compare(MarketingEntry o1, MarketingEntry o2) {
                if (o1.getGroupId() == o2.getGroupId()) {
                    return o1.getSortNum() - o2.getSortNum();
                } else {
                    return o1.getGroupId() - o2.getGroupId();
                }
            }
        });

        for (MarketingEntry entry : entries) {
            if (Config.SYSTEM_ENV.equals("online") && version.compareTo(entry.getVersion()) < 0) {
                continue;
            }

            // 权限不允许
            if (map.get(entry.getPermissionCode()) != null && map.get(entry.getPermissionCode()) == 1) {
                continue;
            }

            // 这里需要根据机构的版本类型 白金版 免费版来判断促销图标url是否要显示
            TXAccount txAccount = txAccountService.getTXAccountByOrgId(orgId);

            if (entry.getEvent().equals("tx_event_smartpromotion")) {
                if (hasSmartPromote) {
                    MarketingEntryDto dto = MarketingEntryDto.createFromMarketingEntry(entry, txAccount);
                    entryMap.put(dto.getId(), dto);
                }
            } else {

                // 1.7版本以上营销4合一接口统一用 tx_event_activity_merge事件
                if (version.compareTo(Config.VERSION_1_7) < 0
                    && entry.getEvent().equals(MarketingEntryEnventEnum.ACTIVITY_MERGE_ENVENT.getEvent())) {
                    continue;
                } else if (version.compareTo(Config.VERSION_1_7) >= 0
                    && MarketingEntryEnventEnum.getActivityMarketingEntryEventList().contains(entry.getEvent())) {
                    continue;
                } else {
                    MarketingEntryDto dto = MarketingEntryDto.createFromMarketingEntry(entry, txAccount);
                    entryMap.put(dto.getId(), dto);
                }
            }
        }

        Set<Integer> keySet = entryMap.keySet();

        for (Iterator<Integer> iterator = keySet.iterator(); iterator.hasNext();) {
            Integer key = iterator.next();
            MarketingEntryDto dto = entryMap.get(key);

            if (dto.getParentId() <= 0) {
                dtoList.add(dto);
            } else {
                MarketingEntryDto parentEntry = entryMap.get(dto.getParentId());
                if (parentEntry != null) {
                    parentEntry.getSubEntries().add(dto);
                }
            }
        }

        return dtoList;
    }

}
