/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.utils.CharUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {
    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);
    public static final int UCS2_LENGTH = 70;
    public static final int _7_BIT_LENGTH = 160;

    public static int countContentSimple(String content) {
        if (GenericsUtils.isNullOrEmpty((Object)content)) {
            return 0;
        }
        char[] chars = content.trim().toCharArray();
        boolean isAllUS = true;
        int contentLength = chars.length;
        for (char ch : chars) {
            if (!CharUtils.isChineseChar(ch) || !isAllUS) continue;
            isAllUS = false;
            break;
        }
        int singleSmsLimit = 70;
        if (isAllUS) {
            singleSmsLimit = -160;
        }
        int dev = contentLength / singleSmsLimit;
        return contentLength % singleSmsLimit == 0 ? dev : dev + 1;
    }

    public static int countContent(String content) {
        if (GenericsUtils.isNullOrEmpty((Object)content)) {
            return 0;
        }
        boolean isAllEng = CharUtils.isAllUS(content);
        content = content.trim();
        char[] charArray = content.toCharArray();
        int singleSmsLimit = 70;
        int contentLength = 0;
        if (isAllEng) {
            contentLength = charArray.length;
            singleSmsLimit = 160;
        } else {
            contentLength = charArray.length * 2;
        }
        log.info("sms content's length is :{}(byte)", (Object)contentLength);
        int dev = contentLength / singleSmsLimit;
        return contentLength % singleSmsLimit == 0 ? dev : dev + 1;
    }
}

