/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.util.GenericsUtils;
import java.util.regex.Pattern;

public class CharUtils {
    public static boolean isChineseChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isContainChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!CharUtils.isChineseChar(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseByREG(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str.trim()).find();
    }

    @Deprecated
    public static boolean isChineseByName(String str) {
        if (str == null) {
            return false;
        }
        String reg = "\\p{InCJK Unified Ideographs}&&\\P{Cn}";
        Pattern pattern = Pattern.compile(reg);
        return pattern.matcher(str.trim()).find();
    }

    public static boolean isAllUS(String content) {
        if (GenericsUtils.isNullOrEmpty((Object)content)) {
            return true;
        }
        return (content = content.trim()).equals(content.replaceAll("[^-a-zA-Z0-9,./\\;'\\]\\[|\\}\\{\":?><~`@#$%^&*()_\u20ac\u03c0+=\\s]+", ""));
    }

    public static void main(String[] args) {
        String content = "fdsaf fdsafdsjk ,afjdskfads";
        System.out.println(CharUtils.isAllUS(content));
    }
}

