/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.ActivityAccessLogService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityAccessLogServiceImpl
implements ActivityAccessLogService {
    private static final Logger log = LoggerFactory.getLogger(ActivityAccessLogServiceImpl.class);
    @Autowired
    private ActivityAccessLogDao accessLogDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;

    @Override
    public List<DairyCountStatistics> getLastDayLog(Long activityId, List<String> dateList, TemplateTypeCategory category) {
        List list = this.accessLogDao.selectActivityAccessLogByDate(dateList, activityId, category.getType());
        ArrayList<DairyCountStatistics> statisticsList = new ArrayList<DairyCountStatistics>();
        if (list != null && list.size() > 0) {
            for (ActivityAccessLog log : list) {
                statisticsList.add(new DairyCountStatistics(log.getAccessDate(), log.getAccessCount()));
            }
        }
        return statisticsList;
    }

    @Override
    public int getTotalAccessCount(Long activityId, TemplateTypeCategory category) {
        Map map = this.accessLogDao.selectTotalByActivityId(Arrays.asList(activityId), category.getType());
        return map.get(activityId) == null ? 0 : (Integer)map.get(activityId);
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void setTodayAccessCount(Long activityId, TemplateTypeCategory category) {
        ActivityAccessLog accessLog;
        String dateStr = DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd");
        List accessLogs = this.accessLogDao.selectActivityAccessLogByDate(Arrays.asList(dateStr), activityId, category.getType());
        log.info("[ActivityAccessLog] accessLogs1 param:{}", (Object)accessLogs);
        if (accessLogs == null || accessLogs.isEmpty()) {
            log.info("[ActivityAccessLog] accessLogs2 param:{}", (Object)accessLogs);
            accessLog = new ActivityAccessLog();
            accessLog.setAccessCount(1);
            accessLog.setAccessDate(dateStr);
            accessLog.setActivityId(activityId.longValue());
            accessLog.setUpdateTime(new Date());
            accessLog.setCategory(category.getType());
            this.accessLogDao.insertActivityAccessLog(accessLog);
        } else {
            accessLog = (ActivityAccessLog)accessLogs.get(0);
            accessLog.setAccessCount(accessLog.getAccessCount() + 1);
            this.accessLogDao.update((Object)accessLog, new String[0]);
        }
        int accessAccount = this.getTotalAccessCount(activityId, category);
        log.info("accessAccount:{}", (Object)accessAccount);
        TxActivityCommon conf = this.txActivityCommonDao.getTxActivityCommon(null, Integer.valueOf(category.getTypeId()), activityId);
        conf.setAccessCount(Integer.valueOf(accessAccount));
        this.txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "accessCount");
    }
}

