/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.draw.service.ActivityUserService;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteResult;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteStatisticsService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoteStatisticsServiceImpl
implements VoteStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(VoteStatisticsServiceImpl.class);
    private static final int VOTE_ACTIVITY_CATEGORY = TemplateTypeCategory.VOTE_TYPE.getType();
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private ActivityUserService activityUserService;
    @Autowired
    private VoteOptionDao voteOptionDao;

    @Override
    public List<DairyCountStatistics> accessDairyCountStatistics(Long activityId, Long orgId, List<String> dateList) {
        boolean check = this.validateActivity(activityId, orgId);
        if (!check) {
            return Collections.emptyList();
        }
        ArrayList<DairyCountStatistics> retResults = new ArrayList<DairyCountStatistics>();
        ArrayList logs = this.activityAccessLogDao.selectActivityAccessLogByDate(dateList, activityId, VOTE_ACTIVITY_CATEGORY);
        if (GenericsUtils.isNullOrEmpty((Object)logs)) {
            logs = new ArrayList();
        }
        Map logMaps = CollectionUtils.extractMap(logs, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, ActivityAccessLog>(){

            public String extract(ActivityAccessLog arg0) {
                return arg0.getAccessDate();
            }
        });
        Integer count = 0;
        for (String date : dateList) {
            DairyCountStatistics dcs = new DairyCountStatistics();
            ActivityAccessLog log = (ActivityAccessLog)logMaps.get(date);
            if (log != null) {
                count = log.getAccessCount();
            }
            dcs.setCount(count.intValue());
            dcs.setDate(date);
            count = 0;
            retResults.add(dcs);
        }
        return retResults;
    }

    private boolean validateActivity(Long activityId, Long orgId) {
        VoteInfo voteInfo = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        if (voteInfo == null) {
            log.info("can not find any activity with activityId:{} and orgId:{}", (Object)activityId, (Object)orgId);
            return false;
        }
        return true;
    }

    @Override
    public List<DairyCountStatistics> partakeDairyCountStatistics(Long activityId, Long orgId) {
        VoteInfo vi = this.voteInfoDao.selectVoteInfo(activityId, orgId);
        Timestamp startDate = vi.getStartTime();
        Timestamp endDate = vi.getEndTime();
        List<DairyCountStatistics> dairyCountStatistics = this.activityUserService.getActivityUserStatistics(activityId, VOTE_ACTIVITY_CATEGORY, startDate, endDate);
        if (GenericsUtils.isNullOrEmpty(dairyCountStatistics)) {
            return Collections.emptyList();
        }
        return dairyCountStatistics;
    }

    @Override
    public List<VoteResult> votedDairyCountStatistics(Long activityId, Long orgId) {
        boolean isCheck = this.validateActivity(activityId, orgId);
        if (!isCheck) {
            return Collections.emptyList();
        }
        List<Long> activityIds = Arrays.asList(activityId);
        Map statisticalVotes = this.activityUserDao.statisticalVotes(activityIds, Integer.valueOf(VOTE_ACTIVITY_CATEGORY));
        if (GenericsUtils.isNullOrEmpty((Object)statisticalVotes)) {
            return Collections.emptyList();
        }
        Map votedResults = (Map)statisticalVotes.get(activityId);
        HashSet<Long> optionsIds = new HashSet<Long>(votedResults.size());
        for (Map.Entry entry : votedResults.entrySet()) {
            optionsIds.add((Long)entry.getKey());
        }
        List voteOptions = this.voteOptionDao.selectVoteOptionsByVoteId(activityId);
        if (GenericsUtils.isNullOrEmpty((Object)voteOptions)) {
            return Collections.emptyList();
        }
        Integer num = 1;
        ArrayList<VoteResult> retResults = new ArrayList<VoteResult>();
        for (VoteOption voteOption : voteOptions) {
            Long optionsId = voteOption.getId();
            VoteResult vr = new VoteResult();
            Integer count = (Integer)votedResults.get(optionsId);
            if (count == null) {
                count = 0;
            }
            Integer n = num;
            num = n + 1;
            vr.setNumber(n);
            vr.setName(voteOption.getName());
            vr.setCount(count);
            retResults.add(vr);
        }
        return retResults;
    }
}

