/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendRequest;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.beust.jcommander.internal.Lists;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class SmsGroupSendListDto
implements Cloneable {
    public static final Integer truncatureContentLength = 20;
    public static final Integer truncatureNameLength = 20;
    public static final String splitSymbol = "\u3001";
    private Long recordId;
    private Long sendTime;
    private String receivers;
    private String content;
    private Integer count;
    @JsonIgnore
    private String truncatureNamesStr;
    @JsonIgnore
    private String truncatureContentStr;

    public static SmsGroupSendListDto newInstance(SmsGroupSendRecord record) {
        return SmsGroupSendListDto.newInstance(record, null);
    }

    public static SmsGroupSendListDto newInstance(SmsGroupSendRecord record, List<StudentDto> studentLists) {
        String content;
        SmsGroupSendListDto ret = new SmsGroupSendListDto();
        ret.setRecordId(record.getId());
        Timestamp time = record.getSendTime();
        if (time != null) {
            ret.setSendTime(time.getTime());
        }
        content = GenericsUtils.isNullOrEmpty((Object)(content = record.getContent())) ? "EMPTY CONTENT" : content;
        ret.setContent(record.getContent());
        ret.setCount(record.getTotalCount());
        if (content.length() > truncatureContentLength) {
            ret.setTruncatureContentStr(content.substring(0, truncatureContentLength));
        }
        if (GenericsUtils.notNullAndEmpty(studentLists)) {
            if (ret.getCount() == null || ret.getCount() == 0) {
                ret.setCount(studentLists.size());
            }
            String extractReceiverNames = SmsGroupSendRequest.extractReceiverNames(studentLists);
            ret.setReceivers(extractReceiverNames);
            if (studentLists.size() > truncatureNameLength) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < truncatureNameLength) {
                    sb.append(studentLists.get(i).getName()).append(splitSymbol);
                    ++i;
                }
                ret.setTruncatureNamesStr(GenericsUtils.deleteLastCharToString((StringBuilder)sb));
            }
        }
        return ret;
    }

    public static List<SmsGroupSendListDto> buildTurncatureResp(List<SmsGroupSendListDto> dtos) {
        if (GenericsUtils.isNullOrEmpty(dtos)) {
            return Collections.emptyList();
        }
        List retDtos = Lists.newArrayList((int)dtos.size());
        for (SmsGroupSendListDto dto : dtos) {
            SmsGroupSendListDto newDto = (SmsGroupSendListDto)dto.clone();
            if (GenericsUtils.notNullAndEmpty((Object)newDto.getTruncatureContentStr())) {
                newDto.setContent(newDto.getTruncatureContentStr());
            }
            if (GenericsUtils.notNullAndEmpty((Object)dto.getTruncatureNamesStr())) {
                newDto.setReceivers(newDto.getTruncatureNamesStr());
            }
            retDtos.add(newDto);
        }
        return retDtos;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public Long getSendTime() {
        return this.sendTime;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getTruncatureNamesStr() {
        return this.truncatureNamesStr;
    }

    public String getTruncatureContentStr() {
        return this.truncatureContentStr;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public void setSendTime(Long sendTime) {
        this.sendTime = sendTime;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setTruncatureNamesStr(String truncatureNamesStr) {
        this.truncatureNamesStr = truncatureNamesStr;
    }

    public void setTruncatureContentStr(String truncatureContentStr) {
        this.truncatureContentStr = truncatureContentStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsGroupSendListDto)) {
            return false;
        }
        SmsGroupSendListDto other = (SmsGroupSendListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recordId = this.getRecordId();
        Long other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
            return false;
        }
        Long this$sendTime = this.getSendTime();
        Long other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        if (this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$truncatureNamesStr = this.getTruncatureNamesStr();
        String other$truncatureNamesStr = other.getTruncatureNamesStr();
        if (this$truncatureNamesStr == null ? other$truncatureNamesStr != null : !this$truncatureNamesStr.equals(other$truncatureNamesStr)) {
            return false;
        }
        String this$truncatureContentStr = this.getTruncatureContentStr();
        String other$truncatureContentStr = other.getTruncatureContentStr();
        return !(this$truncatureContentStr == null ? other$truncatureContentStr != null : !this$truncatureContentStr.equals(other$truncatureContentStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsGroupSendListDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
        Long $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $truncatureNamesStr = this.getTruncatureNamesStr();
        result = result * 59 + ($truncatureNamesStr == null ? 43 : $truncatureNamesStr.hashCode());
        String $truncatureContentStr = this.getTruncatureContentStr();
        result = result * 59 + ($truncatureContentStr == null ? 43 : $truncatureContentStr.hashCode());
        return result;
    }

    public String toString() {
        return "SmsGroupSendListDto(recordId=" + this.getRecordId() + ", sendTime=" + this.getSendTime() + ", receivers=" + this.getReceivers() + ", content=" + this.getContent() + ", count=" + this.getCount() + ", truncatureNamesStr=" + this.getTruncatureNamesStr() + ", truncatureContentStr=" + this.getTruncatureContentStr() + ")";
    }
}

