/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.draw.dto;

import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DrawCacheDto
implements Serializable {
    private static final long serialVersionUID = -7500214170704502841L;
    private Long startTime;
    private Long endTime;
    private int limitCount;
    private int baseNum;
    private Long orgId;
    private int templateId;
    private int status = 1;
    private PrizeInfo[] prizes;
    private int[] probabilities;
    private Integer delStatus;
    private Integer infoFillStatus;

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public int getBaseNum() {
        return this.baseNum;
    }

    public void setBaseNum(int baseNum) {
        this.baseNum = baseNum;
    }

    public PrizeInfo[] getPrizes() {
        return this.prizes;
    }

    public void setPrizes(PrizeInfo[] prizes) {
        this.prizes = prizes;
    }

    public int[] getProbabilities() {
        return this.probabilities;
    }

    public void setProbabilities(int[] probabilities) {
        this.probabilities = probabilities;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static DrawCacheDto getInstance(DrawInfo drawInfo, List<PrizeInfo> prizeInfos) {
        DrawCacheDto dto = new DrawCacheDto();
        dto.setStartTime(drawInfo.getStartTime().getTime());
        dto.setEndTime(drawInfo.getEndTime().getTime());
        dto.setLimitCount(drawInfo.getCountLimit());
        dto.setBaseNum(DrawCacheDto.getBase(prizeInfos));
        dto.setTemplateId(drawInfo.getTemplateId());
        dto.setOrgId(drawInfo.getOrgId());
        dto.setStatus(drawInfo.getStatus());
        dto.setDelStatus(drawInfo.getDelStatus());
        dto.setInfoFillStatus(drawInfo.getInfoFillStatus());
        PrizeInfo[] prizes = new PrizeInfo[prizeInfos.size()];
        int[] probabilities = new int[prizeInfos.size()];
        int i = 0;
        while (i < prizeInfos.size()) {
            prizes[i] = prizeInfos.get(i);
            probabilities[i] = prizes[i].getProbability().multiply(new BigDecimal(dto.getBaseNum())).intValue();
            ++i;
        }
        dto.setProbabilities(probabilities);
        dto.setPrizes(prizes);
        return dto;
    }

    private static int getBase(List<PrizeInfo> prizeInfos) {
        int max = 1;
        for (PrizeInfo prize : prizeInfos) {
            int length;
            String str = prize.getProbability().toString();
            int index = str.indexOf(".");
            if (index != -1) {
                str = str.substring(index);
            }
            if ((length = str.length()) <= max) continue;
            max = length;
        }
        return (int)Math.pow(10.0, max - 1);
    }

    public static void main(String[] args) {
        ArrayList<PrizeInfo> prizeInfos = new ArrayList<PrizeInfo>();
        PrizeInfo info = new PrizeInfo();
        info.setProbability(new BigDecimal("1"));
        prizeInfos.add(info);
        System.out.println(DrawCacheDto.getBase(prizeInfos));
    }

    public Integer getDelStatus() {
        return this.delStatus;
    }

    public Integer getInfoFillStatus() {
        return this.infoFillStatus;
    }

    public void setDelStatus(Integer delStatus) {
        this.delStatus = delStatus;
    }

    public void setInfoFillStatus(Integer infoFillStatus) {
        this.infoFillStatus = infoFillStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DrawCacheDto)) {
            return false;
        }
        DrawCacheDto other = (DrawCacheDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        if (this.getLimitCount() != other.getLimitCount()) {
            return false;
        }
        if (this.getBaseNum() != other.getBaseNum()) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        if (this.getTemplateId() != other.getTemplateId()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPrizes(), other.getPrizes())) {
            return false;
        }
        if (!Arrays.equals(this.getProbabilities(), other.getProbabilities())) {
            return false;
        }
        Integer this$delStatus = this.getDelStatus();
        Integer other$delStatus = other.getDelStatus();
        if (this$delStatus == null ? other$delStatus != null : !((Object)this$delStatus).equals(other$delStatus)) {
            return false;
        }
        Integer this$infoFillStatus = this.getInfoFillStatus();
        Integer other$infoFillStatus = other.getInfoFillStatus();
        return !(this$infoFillStatus == null ? other$infoFillStatus != null : !((Object)this$infoFillStatus).equals(other$infoFillStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DrawCacheDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        result = result * 59 + this.getLimitCount();
        result = result * 59 + this.getBaseNum();
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        result = result * 59 + this.getTemplateId();
        result = result * 59 + this.getStatus();
        result = result * 59 + Arrays.deepHashCode(this.getPrizes());
        result = result * 59 + Arrays.hashCode(this.getProbabilities());
        Integer $delStatus = this.getDelStatus();
        result = result * 59 + ($delStatus == null ? 43 : ((Object)$delStatus).hashCode());
        Integer $infoFillStatus = this.getInfoFillStatus();
        result = result * 59 + ($infoFillStatus == null ? 43 : ((Object)$infoFillStatus).hashCode());
        return result;
    }

    public String toString() {
        return "DrawCacheDto(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limitCount=" + this.getLimitCount() + ", baseNum=" + this.getBaseNum() + ", orgId=" + this.getOrgId() + ", templateId=" + this.getTemplateId() + ", status=" + this.getStatus() + ", prizes=" + Arrays.deepToString(this.getPrizes()) + ", probabilities=" + Arrays.toString(this.getProbabilities()) + ", delStatus=" + this.getDelStatus() + ", infoFillStatus=" + this.getInfoFillStatus() + ")";
    }
}

