/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.activity.dto.AreaDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.AreaSerachRequest;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaSearchUtils {
    private static Logger logger = LoggerFactory.getLogger(AreaSearchUtils.class);

    public static List<AreaDto> searchAreas(AreaSerachRequest request) {
        String url = "http://tapi.genshuixue.com/area/list";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("p_id", String.valueOf(request.getpId()));
        params.put("level", String.valueOf(request.getLevel()));
        String charset = "utf-8";
        try {
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            BasicHeader head1 = new BasicHeader("content_Type", "application/x-www-form-urlencoded");
            headers.add(head1);
            String doJsonPost = HttpClientUtils.doPost((String)url, params, (String)charset, headers);
            JSONObject fromObject = JSONObject.fromObject((Object)doJsonPost);
            Integer code = fromObject.getInt("code");
            if (code != null && code == 1) {
                JSONObject resultObj = fromObject.getJSONObject("result");
                if (resultObj == null) {
                    return Collections.emptyList();
                }
                JSONArray jsonArray = resultObj.getJSONArray("list");
                int length = jsonArray.size();
                ArrayList<AreaDto> areaDtos = new ArrayList<AreaDto>(length);
                Gson gson = new Gson();
                int i = 0;
                while (i < length) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String json = jsonObject.toString();
                    areaDtos.add((AreaDto)gson.fromJson(json, AreaDto.class));
                    ++i;
                }
                return areaDtos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("can not find any sub area with pid : {} in level {}", (Object)request.getpId(), (Object)request.getLevel());
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) {
        AreaSerachRequest request = new AreaSerachRequest();
        List<AreaDto> searchAreas = AreaSearchUtils.searchAreas(request);
        System.out.println(searchAreas);
    }
}

