/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.dtos;

import com.baijia.tianxiao.dal.activity.po.MarketingEntry;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.marketing.commons.enums.SystemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class MarketingEntryDto
extends MarketingEntry {
    private static final Logger log = LoggerFactory.getLogger(MarketingEntryDto.class);
    private List<MarketingEntryDto> subEntries = new ArrayList<MarketingEntryDto>();
    private int group;

    public static MarketingEntryDto createFromMarketingEntry(MarketingEntry entry, TXAccount txAccount) {
        MarketingEntryDto dto = new MarketingEntryDto();
        BeanUtils.copyProperties((Object)entry, (Object)((Object)dto));
        dto.setGroup(entry.getGroupId());
        String vipLevel = entry.getVipLevel();
        String promotionIconUrl = null;
        log.info("[MarketingEntry] vipLevel param:{}, txAccount.getVipLevel() param:{}", (Object)vipLevel, (Object)txAccount.getVipLevel());
        if (StringUtils.isNotBlank((CharSequence)vipLevel)) {
            Integer vipProxy;
            List<String> vipLevelList = Arrays.asList(vipLevel.split(","));
            Integer n = vipProxy = TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode((Integer)txAccount.getVipLevel())) ? TXAccountType.BAIJIN.getCode() : txAccount.getVipLevel();
            if (vipLevelList.contains(vipProxy.toString())) {
                promotionIconUrl = entry.getPromotionIconUrl();
            }
        }
        dto.setPromotionIconUrl(promotionIconUrl == null ? "" : promotionIconUrl);
        if (StringUtils.isNotBlank((CharSequence)dto.getUrl())) {
            dto.setUrl(SystemType.getDomain(dto.getSysType()) + "/" + dto.getUrl());
        }
        return dto;
    }

    public static void main(String[] args) {
        String vipLevel = "6";
        List<String> vipLevelList = Arrays.asList(vipLevel.split(","));
        System.out.println(vipLevelList);
    }

    public List<MarketingEntryDto> getSubEntries() {
        return this.subEntries;
    }

    public int getGroup() {
        return this.group;
    }

    public void setSubEntries(List<MarketingEntryDto> subEntries) {
        this.subEntries = subEntries;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketingEntryDto)) {
            return false;
        }
        MarketingEntryDto other = (MarketingEntryDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<MarketingEntryDto> this$subEntries = this.getSubEntries();
        List<MarketingEntryDto> other$subEntries = other.getSubEntries();
        if (this$subEntries == null ? other$subEntries != null : !((Object)this$subEntries).equals(other$subEntries)) {
            return false;
        }
        return this.getGroup() == other.getGroup();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarketingEntryDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MarketingEntryDto> $subEntries = this.getSubEntries();
        result = result * 59 + ($subEntries == null ? 43 : ((Object)$subEntries).hashCode());
        result = result * 59 + this.getGroup();
        return result;
    }

    public String toString() {
        return "MarketingEntryDto(subEntries=" + this.getSubEntries() + ", group=" + this.getGroup() + ")";
    }
}

