
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import java.util.List;

import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 19, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class RecordRespDto extends SmsGroupSendResp {

    public static final int limit = Integer.parseInt(
        GenericsUtils.isNullOrEmpty(Config.LOCAL_BATCH_SEND_COUNT_LIMIT) ? "100" : Config.LOCAL_BATCH_SEND_COUNT_LIMIT);

    public static final int system_limit =
        Integer.parseInt(GenericsUtils.isNullOrEmpty(Config.SYSTEM_BATCH_SEND_COUNT_LIMIT) ? "1000"
            : Config.SYSTEM_BATCH_SEND_COUNT_LIMIT);

    private Long recordId;
    private int sendStatus; // 系统群发短信发送状态 0:系统网关发送成功 1:短信额度不足,无法完成短信发送 2:本地发送短信数量超限 3:系统发送失败.
    private int leftSmsCount; // 剩余网关短信的额度(条),在发送成功的时候不返回.
    private int localBatchSendCount; // 本地短信发送允许发送的条数上限
    @JsonIgnore
    private Integer code = SendStatus.SEND_OK.getCode();

    /**
     * @param id
     * @param studentDtos
     * @return
     * @Desc
     */
    public static RecordRespDto buildDto(Long id, List<StudentDto> studentDtos) {
        RecordRespDto resp = new RecordRespDto();
        resp.setRecordId(id);
        resp.setTotalStuCount(studentDtos.size());
        return resp;
    }

    public static RecordRespDto buildDto(Long recordId, int totalStuCount, int leftSmsCount, int sendStatus,
        Integer respCode) {
        RecordRespDto resp = new RecordRespDto();
        resp.setRecordId(recordId);
        resp.setTotalStuCount(totalStuCount);
        // 如果额度<=0 , 则返回app为0
        if (leftSmsCount <= 0) {
            leftSmsCount = 0;
        }
        resp.setLeftSmsCount(leftSmsCount);
        resp.setLocalBatchSendCount(limit);
        resp.setSendStatus(sendStatus);
        if (respCode != null) {
            resp.setCode(respCode);
        }
        return resp;
    }

}
