package com.baijia.tianxiao.sal.marketing.draw.dto;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;

import org.apache.commons.beanutils.BeanUtils;

import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 11:49:33 AM
 * @desc :
 */
public class PrizeInfoDto implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 4900604544355900912L;

    public static final BigDecimal PERCENTAGE_100 = new BigDecimal(100);

    private Long id;
    private Long activityId;
    private String name; // 奖品名称
    private Integer countLimit = 0; // 奖品数量
    private String url; // 奖品展示图片的url
    private String probability; // 奖品的中奖概率，这里为百分之几,注意，是0.0x%
    private Integer number; // 奖品每天的中奖个数
    private Integer grade;

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProbability() {
        return probability;
    }

    public void setProbability(String probability) {
        this.probability = probability;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public String toString() {
        return "PrizeInfoDto [name=" + name + ", countLimit=" + countLimit + ", url=" + url + ", probability="
            + probability + ", number=" + number + "]";
    }

    /**
     * dto ----> po
     * 
     * @param prizeInfoDto
     * @return
     */
    public PrizeInfo buildPo() {
        PrizeInfo pi = new PrizeInfo();
        try {
            BeanUtils.copyProperties(pi, this);
            pi.setProbability(new BigDecimal(this.getProbability()).divide(PERCENTAGE_100));
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return pi;
    }

    /**
     * po -----> dto
     * 
     * @param prizeInfo
     * @return
     */
    public static PrizeInfoDto buildDto(PrizeInfo prizeInfo) {
        PrizeInfoDto prizeInfoDto = new PrizeInfoDto();
        try {
            BeanUtils.copyProperties(prizeInfoDto, prizeInfo);
            prizeInfoDto.setProbability(
                prizeInfo.getProbability().multiply(PERCENTAGE_100).toString().replaceAll("([\\d.]+[^0])0+", "$1"));
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return prizeInfoDto;
    }

    public static void main(String[] args) {
        // PrizeInfoDto pid = new PrizeInfoDto();
        // pid.setCountLimit(12);
        // pid.setName("北京一等奖");
        // pid.setNumber(12);
        // pid.setProbability("0.04");
        // pid.setUrl("http://www.baidu.com/");
        // PrizeInfo pi = pid.buildPo(pid);
        // System.out.println(pi);

        PrizeInfo pi = new PrizeInfo();
        pi.setCountLimit(12);
        pi.setName("北京一等奖");
        pi.setNumber(12);
        pi.setProbability(new BigDecimal("0.000704800"));
        pi.setUrl("http://www.baidu.com/");
        PrizeInfoDto pid = PrizeInfoDto.buildDto(pi);
        System.out.println(pid);
    }

}
