package com.baijia.tianxiao.sal.marketing.draw.dto;

import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.util.GenericsUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 11:36:45 AM
 * @desc :
 */
public class DrawActivityDetail extends DrawActivityBase {
    private List<PrizeInfoDto> prizeList; // 奖品信息

    private Integer adStatus; // 是否开启广告位
    private String slogan; // 广告语
    private String adUrl; // 广告链接页面的url
    private Integer templateTypeId; // 当前抽奖活动的模板类型id
    private Integer templateId; // 当前抽奖活动的模板类型id
    private Integer isCheck;
    private String shareUrl;//分享短链

    /**
     * po ----> dto
     *
     * @return
     */
    public static DrawActivityDetail buildDetailDto(DrawInfo drawInfo, List<PrizeInfo> prizeInfos) {
        DrawActivityDetail di = new DrawActivityDetail();
        // 进行基本信息填充
        di.buildDto(drawInfo);
        if (GenericsUtils.notNullAndEmpty(prizeInfos)) {
            // 进行中奖信息的填充
            List<PrizeInfoDto> prizeInfoDtos = new ArrayList<>();
            for (PrizeInfo prizeInfo : prizeInfos) {
                prizeInfoDtos.add(PrizeInfoDto.buildDto(prizeInfo));
            }
            di.setPrizeList(prizeInfoDtos);
        }
        return di;
    }

    /**
     * dto -----> po
     * 
     * @param detail
     * @return
     */
    public static <T extends DrawActivityDetail> TwoTuple<DrawInfo, List<PrizeInfo>> buildDetailPo(T detail) {
        // 获取到基本的抽奖活动的信息
        DrawInfo di = detail.buildPo();
        // 获取到抽奖活动的奖品信息
        List<PrizeInfo> prizeInfos = new ArrayList<>();
        List<PrizeInfoDto> prizeInfosDtos = detail.getPrizeList();
        if (GenericsUtils.notNullAndEmpty(prizeInfosDtos)) {
            for (PrizeInfoDto prizeInfoDto : prizeInfosDtos) {
                prizeInfos.add(prizeInfoDto.buildPo());
            }
        }
        return TupleUtil.tuple(di, prizeInfos);
    }

    public Integer getIsCheck() {
        return isCheck;
    }

    public void setIsCheck(Integer isCheck) {
        this.isCheck = isCheck;
    }

    public Integer getTemplateTypeId() {
        return templateTypeId;
    }

    public void setTemplateTypeId(Integer templateTypeId) {
        this.templateTypeId = templateTypeId;
    }

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Integer getAdStatus() {
        return adStatus;
    }

    public void setAdStatus(Integer adStatus) {
        this.adStatus = adStatus;
    }

    public String getSlogan() {
        return slogan;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public String getAdUrl() {
        return adUrl;
    }

    public void setAdUrl(String adUrl) {
        this.adUrl = adUrl;
    }

    public List<PrizeInfoDto> getPrizeList() {
        return prizeList;
    }

    public void setPrizeList(List<PrizeInfoDto> prizeList) {
        this.prizeList = prizeList;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }
    
}
