/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.TxOrgVersionConsultDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.TxOrgVersionConsult;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.ActivityAmountDto;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityCommonFilterParams;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityMergeDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ActivityMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年8月22日
 * @desc
 */
@Service
@Slf4j
public class TxActivityCommonServiceImpl implements TxActivityCommonService{

    @Autowired
    private TxActivityCommonDao txActivityCommonDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private TxOrgVersionConsultDao txOrgVersionConsultDao;
    
    private static String CONSULT_BAIJIN_SUBJECT = "大众版天校机构咨询升级白金版";
    
    @Override
    public List<TxActivityMergeDto> getTxActivityMergeDtoList(Long orgId, PageDto pageDto, TxActivityCommonFilterParams filterParams) {
        List<Integer> typeIds = new ArrayList<>();
        Integer templateType = filterParams.getTemplateType();
        if(templateType == null){
            typeIds = TemplateTypeCategory.getTypeIdList();
        }else{
            typeIds.add(TemplateTypeCategory.getTemplateTypeCategoryByType(templateType).getTypeId());
        }
        log.info("[ActivityMerge] typeIds param:{}", typeIds);
        
        List<TxActivityMergeDto> activityMergeDtoList = new ArrayList<>();
        
        List<TxActivityCommon> txActivityCommonList = txActivityCommonDao.getTxActivityList(orgId, typeIds, pageDto, filterParams.getIsSortedByPopular(), filterParams.getStatus());
        
        if(GenericsUtils.notNullAndEmpty(txActivityCommonList)){
            for(TxActivityCommon conf : txActivityCommonList){
                TxActivityMergeDto dto = TxActivityMergeDto.buildInstanceByTxAcitivityConf(conf, filterParams.getStatus());
                activityMergeDtoList.add(dto);
            }
        }else{
            return Collections.EMPTY_LIST;
        }
        
        return activityMergeDtoList;
    }
    @Override
    public void saveOrUpdateTxActivityCommon(TxActivityCommon conf, TemplateTypeCategory templateTypeCategory, Object activityInfo, ActivityConf blackboardActivityConfInfo, String... saveProp) {
        log.info("[ActivityMerge] conf param:{}, activityInfo param:{}", conf, activityInfo);
        //判断
        if(templateTypeCategory != null){
            switch (templateTypeCategory) {
                case DRAW_TYPE:
                    setTxActivityCommonByDrawInfo(conf, (DrawInfo) activityInfo);
                    break;
                case VOTE_TYPE:
                    setTxActivityCommonByVoteInfo(conf, (VoteInfo) activityInfo);
                    break;
                case REFERRAL_TYPE:
                    setTxActivityCommonByReferralInfo(conf, (ReferralInfo) activityInfo);
                    break;
                case COMMON_TYPE:
                    setTxActivityCommonByBlackboardActivityInfo(conf, (Activity) activityInfo, blackboardActivityConfInfo);
                    break;
            }
        }
        conf.setUpdateTime(new Date());
        log.info("[ActivityMerge] conf param:{}", conf);
        log.info("[ActivityMerge] templateTypeCategory param:{}, activityInfo param:{}, blackboardActivityConfInfo param:{}", templateTypeCategory, activityInfo, blackboardActivityConfInfo);
        
        txActivityCommonDao.saveOrUpdate(conf, saveProp);
    }
    
    @Override
    @Transactional("yunyingTransactionManager")
    public void synchronousActivityData(Integer type) {
        TemplateTypeCategory templateTypeCategory = TemplateTypeCategory.getTemplateTypeCategoryByType(type);
        
        //需要判断该活动是否已经同步过 获取所有活动配置
        List<TxActivityCommon> existConfs = this.txActivityCommonDao.getAll();
        Map<Integer, List<Long>> activityIdsMapByTypeId = new HashMap<>();
        if(existConfs!= null && existConfs.size() >0){
            for(TxActivityCommon conf : existConfs){
                Integer typeId = conf.getTemplateTypeId();
                Long activityId = conf.getActivityId();
                List<Long> activityIds = activityIdsMapByTypeId.get(typeId);
                if(activityIds == null){
                    activityIds = new ArrayList<>();
                    activityIdsMapByTypeId.put(typeId, activityIds);
                }
                activityIds.add(activityId);
            }
        }
        
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(100);
        pageDto.setPageNum(1);
        
        List<Long> existActivityIds = activityIdsMapByTypeId.get(templateTypeCategory.getTypeId());
        log.info("[TxActivityCommon] existActivityIds param:{}, templateTypeCategory param:{}, size param:{}", existActivityIds, templateTypeCategory);
        
        switch (templateTypeCategory) {
            case DRAW_TYPE:
                //同步抽奖活动
                sysnDraw(pageDto, existActivityIds);
                break;
            case VOTE_TYPE:
                sysnVote(pageDto, existActivityIds);
                break;
            case REFERRAL_TYPE:
                sysnReferral(pageDto, existActivityIds);
                break;
            case COMMON_TYPE:
                //同步微活动数据
                sysnActivity(pageDto, existActivityIds);
                break;
        }
    }
    
    private void sysnActivity(PageDto pageDto, List<Long> existActivityIds){
        List<Activity> activityList = activityDao.getActivityList(pageDto);
        log.info("[TxActivityCommon] activityList param:{}", activityList.size());
        if(activityList != null && activityList.size() >0){
            List<TxActivityCommon> confs = new ArrayList<>();
            
            List<Long> activityIds = new ArrayList<>();
            for(Activity activity : activityList){
                activityIds.add(activity.getId());
            }
            Map<Long,ActivityConf> activityConfMap = this.activityConfDao.getConfigMapByActivityIds(activityIds);
            
            Map<Long,Integer> map = activityAccessLogDao.selectTotalByActivityId(activityIds,TemplateTypeCategory.COMMON_TYPE.getType());
            
            List<Long> sysnActivityIds = new ArrayList<>(); 
            for(Activity activity : activityList){
                if(existActivityIds == null || !existActivityIds.contains(activity.getId())){
                    TxActivityCommon conf = new TxActivityCommon();
                    sysnActivityIds.add(activity.getId());
                    ActivityConf blackboardActivityConfInfo = activityConfMap.get(activity.getId());
                    setTxActivityCommonByBlackboardActivityInfo(conf, activity, blackboardActivityConfInfo);
                    Integer accessCount = map.get(activity.getId());
                    conf.setAccessCount(accessCount == null ? 0 : accessCount);
                    conf.setCreateTime(DateUtil.getStrToDate("yyyy-MM-dd HH:mm:ss", activity.getCreateTime()));
                    conf.setUpdateTime(DateUtil.getStrToDate("yyyy-MM-dd HH:mm:ss", activity.getUpdateTime()));
                    confs.add(conf);
                }
            }
            
            log.info("[TxActivityCommon]  同步的活动 activityIds param:{}, sysnActivityIds param:{} , type:{}", activityIds, "发活动", sysnActivityIds);
            
            if(confs.size() >0){
                this.txActivityCommonDao.saveAll(confs);
            }
            pageDto.setPageNum(pageDto.getPageNum() + 1);
            log.info("[TxActivityCommon] pageDto :{}", pageDto);
            sysnActivity( pageDto, existActivityIds);
        }
        
    }
    
    //同步抽奖活动
    private void sysnDraw(PageDto pageDto, List<Long> existActivityIds){
        List<TxActivityCommon> confs = new ArrayList<>();
        
        List<DrawInfo> drawInfoList = this.drawActivityDao.getAll();
        if(drawInfoList != null && drawInfoList.size() >0){
            List<Long> activityIds = new ArrayList<>();
            for(DrawInfo drawInfo : drawInfoList){
                activityIds.add(drawInfo.getActivityId());
            }
            
            log.info("[TxActivityCommon]  同步的活动 activityIds param:{}, type:{}", activityIds, "抽奖");
            //活动访问人数统计
            Map<Long,Integer> map = activityAccessLogDao.selectTotalByActivityId(activityIds,TemplateTypeCategory.DRAW_TYPE.getType());
            for(DrawInfo drawInfo : drawInfoList){
                if(existActivityIds == null || !existActivityIds.contains(drawInfo.getActivityId())){
                    Integer accessCount = map.get(drawInfo.getActivityId());
                    TxActivityCommon conf = new TxActivityCommon();
                    setTxActivityCommonByDrawInfo(conf, drawInfo);
                    conf.setCreateTime(drawInfo.getCreateTime());
                    conf.setUpdateTime(drawInfo.getUpdateTime());
                    conf.setAccessCount(accessCount == null ? 0 : accessCount);
                    confs.add(conf);
                }
            }
        }
        //保存数据
        if(confs.size() > 0){
            this.txActivityCommonDao.saveAll(confs);
        }
    }
    
    //同步投票数据
    private void sysnVote(PageDto pageDto, List<Long> existActivityIds){
        List<TxActivityCommon> confs = new ArrayList<>();
        
        List<VoteInfo> voteInfoList = this.voteInfoDao.getAll();
        if(voteInfoList != null && voteInfoList.size() >0){
            List<Long> activityIds = new ArrayList<>();
            for(VoteInfo voteInfo : voteInfoList){
                activityIds.add(voteInfo.getActivityId());
            }
            
            log.info("[TxActivityCommon]  同步的活动 activityIds param:{}, type:{}", activityIds, "投票");
            
            //活动访问人数统计
            Map<Long,Integer> map = activityAccessLogDao.selectTotalByActivityId(activityIds,TemplateTypeCategory.VOTE_TYPE.getType());
            for(VoteInfo voteInfo : voteInfoList){
                if(existActivityIds == null || !existActivityIds.contains(voteInfo.getActivityId())){
                    Integer accessCount = map.get(voteInfo.getActivityId());
                    TxActivityCommon conf = new TxActivityCommon();
                    setTxActivityCommonByVoteInfo(conf, voteInfo);
                    conf.setCreateTime(voteInfo.getCreateTime());
                    conf.setUpdateTime(voteInfo.getUpdateTime());
                    conf.setAccessCount(accessCount == null ? 0 : accessCount);
                    confs.add(conf);
                }
            }
            //保存数据
            if(confs.size() >0){
                this.txActivityCommonDao.saveAll(confs);
            }
        }
    }
    
    //同步转介绍数据
    private void sysnReferral(PageDto pageDto, List<Long> existActivityIds){
        List<TxActivityCommon> confs = new ArrayList<>();
        List<ReferralInfo> referralInfoList = this.referralInfoDao.getAll();
        if(referralInfoList != null && referralInfoList.size() >0){
            List<Long> activityIds = new ArrayList<>();
            for(ReferralInfo referralInfo : referralInfoList){
                activityIds.add(referralInfo.getActivityId());
            }
            log.info("[TxActivityCommon]  同步的活动 activityIds param:{}, type:{}, size:{}", activityIds, "转介绍", activityIds.size());
            //活动访问人数统计
            Map<Long,Integer> map = activityAccessLogDao.selectTotalByActivityId(activityIds,TemplateTypeCategory.REFERRAL_TYPE.getType());
            for(ReferralInfo referralInfo : referralInfoList){
                if(existActivityIds == null || !existActivityIds.contains(referralInfo.getActivityId())){
                    Integer accessCount = map.get(referralInfo.getActivityId());
                    TxActivityCommon conf = new TxActivityCommon();
                    setTxActivityCommonByReferralInfo(conf, referralInfo);
                    conf.setCreateTime(referralInfo.getCreateTime());
                    conf.setUpdateTime(referralInfo.getUpdateTime());
                    conf.setAccessCount(accessCount == null ? 0 : accessCount);
                    confs.add(conf);
                }
            }
            
            //保存数据
            if(confs.size() >0){
                this.txActivityCommonDao.saveAll(confs);
            }
        }
    }
    
    //设置TxActivityCommon
    private void setTxActivityCommonByDrawInfo(TxActivityCommon conf, DrawInfo drawInfo){
        BeanUtils.copyProperties(drawInfo, conf);
        conf.setTemplateTypeId(TemplateTypeCategory.DRAW_TYPE.getTypeId());
        conf.setTitle(drawInfo.getName());
    }
    
    private void setTxActivityCommonByVoteInfo(TxActivityCommon conf, VoteInfo voteInfo){
        BeanUtils.copyProperties(voteInfo, conf);
        conf.setTitle(voteInfo.getName());
        conf.setTemplateTypeId(TemplateTypeCategory.VOTE_TYPE.getTypeId());
    }
    
    //设置TxActivityCommon
    private void setTxActivityCommonByReferralInfo(TxActivityCommon conf, ReferralInfo referralInfo){
        BeanUtils.copyProperties(referralInfo, conf);
        conf.setTemplateId(referralInfo.getTemplateId().intValue());
        conf.setTemplateTypeId(TemplateTypeCategory.REFERRAL_TYPE.getTypeId());
    }
    
    //设置TxActivityCommon
    private void setTxActivityCommonByBlackboardActivityInfo(TxActivityCommon conf, Activity activity, ActivityConf blackboardActivityConfInfo){
        conf.setActivityId(activity.getId());
        conf.setTitle(activity.getTitle());
        conf.setOrgId(activity.getOrgId().longValue());
        conf.setTemplateId(blackboardActivityConfInfo.getTemplateId());
        conf.setTemplateTypeId(TemplateTypeCategory.COMMON_TYPE.getTypeId());
        conf.setStartTime(blackboardActivityConfInfo.getStartTime());
        conf.setEndTime(blackboardActivityConfInfo.getEndTime());
        conf.setStatus(activity.getSwitcher());
        conf.setDelStatus(activity.getIsdel());
    }
    @Override
    public ActivityAmountDto getActivityAmountDto(Long orgId) {
        //获取机构当前已经创建的活动，将删除活动排除
        Integer activityTotal = this.txActivityCommonDao.getActivityTotal(orgId);
        ActivityAmountDto dto = new ActivityAmountDto();
        dto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        dto.setMostActivityTotalForFreeVersion(Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION);
        dto.setMostActivityTotalForPayVersion(Config.MOST_ACTIVITY_TOTAL_FOR_PAY_VERSION);
        return dto;
    }
    
    @Override
    @Transactional
    public TwoTuple<Integer, String> saveConsultBaiJinInfo(Long orgId) {
        OrgInfoSimpleDto simple = null;
        try {
            simple = orgInfoService.getOrgInfo(orgId);
        } catch (Exception e) {
            log.info("can not find an org with org_ID {}", orgId);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "机构不存在");
        }
        
        //每个人每天最多可以发5次
        boolean isNotLimited = redisService.addOrgEmailCount(orgId, 0, 0, EmailType.CONSULT_BAIJIN_VERSION);
        if (!isNotLimited) {
            log.info("机构最多每天可以发5封邮件");
            return TupleUtil.tuple(TupleUtil.OK, "提交咨询成功，天校顾问将尽快与您联系");
        }
        String email = ConstantEnums.MAILBOX_CONTACTS_CONSULT_VERSION.value();   //咨询白金版邮件接收人
        String content = getContent(simple);
        String subject = CONSULT_BAIJIN_SUBJECT;  //咨询主题
        Mail mail = ActivityMailSender.createMail(email, null, subject, content);
        try {
            ActivityMailSender.sendMail(email, mail, true);
        } catch (Exception e) {
            log.info("发送邮件失败！e param:{}", e);
            return TupleUtil.tuple(CommonErrorCode.BUSINESS_ERROR.getSubsystemErrorCode(), "发送邮件失败，请稍候再试！");
        }
        
        TxOrgVersionConsult versionConsult = txOrgVersionConsultDao.getTxOrgVersionConsultByOrgId(orgId);
        log.info("[TxActivityCommon] versionConsult:{}", versionConsult);
        if(versionConsult == null){
            versionConsult = new TxOrgVersionConsult();
            versionConsult.setOrgId(orgId);
            versionConsult.setApplyDate(new Date());
            versionConsult.setCreateTime(new Date());
            versionConsult.setApplyType(TXAccountType.BAIJIN.getCode());
            txOrgVersionConsultDao.save(versionConsult);
        }else{
            versionConsult.setApplyDate(new Date());
            txOrgVersionConsultDao.update(versionConsult, "applyDate");
        }
        return TupleUtil.tuple(TupleUtil.OK, "提交咨询成功，天校顾问将尽快与您联系");
    }
    
    private String getContent(OrgInfoSimpleDto simple){
        StringBuffer sb = new StringBuffer();
        sb.append("机构名称：").append(simple.getShortName()== null ? "" : simple.getShortName()).append("</br>");
        sb.append("联系人姓名：").append(simple.getContacts()== null ? "" : simple.getContacts()).append("</br>");
        sb.append("联系电话：").append(simple.getMobile()== null ? "" : simple.getMobile()).append("</br>");
        sb.append("地址：").append(simple.getAddress()== null ? "" : simple.getAddress()).append("</br>");
        sb.append("备注：大众版天校机构咨询升级白金版" );
        return sb.toString();
    }
    
    public static void main(String[] args) {
        OrgInfoSimpleDto simple = new OrgInfoSimpleDto();
        simple.setShortName("nihao");
        simple.setContacts("gaodan");
        StringBuffer sb = new StringBuffer();
        sb.append("机构名称：").append(simple.getShortName()== null ? "" : simple.getShortName()).append("\r\n");
        sb.append("联系人姓名：" + simple.getContacts()== null ? "" : simple.getContacts() + "\r\n");
        System.out.println(sb.toString());
    }
    
    @Override
    public void checkoutOrgActivityVipLevelAndAmount(Long orgId) {
        //判断机构类型 是否是免费版，免费版需要判断
        TXAccount txAccount = txAccountService.getTXAccountByOrgId(orgId.intValue());
        if(txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()){
            ActivityAmountDto dto = this.getActivityAmountDto(orgId);
            log.info("[TxActivityCommon] ActivityAmountDto param:{}", dto);
            if(dto.getActivityTotal() >= Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION){
                log.warn("This organization:{} is free version:{}, the most amount of activity is :{}", orgId, txAccount.getVipLevel(), Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION);
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "大众版天校用户最多可创建" + Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION + "个微活动");
            }
        }else{
            return;
        }
        
    }
    
}
