package com.baijia.tianxiao.sal.marketing.referral.service;

import java.util.List;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;
import com.baijia.tianxiao.sal.marketing.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.marketing.referral.dto.BrokerDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionDetail;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionListDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralCustomer;
import com.baijia.tianxiao.sal.marketing.referral.enums.ReferralCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * Created by liuxp on 16/3/4.
 */
@Service
public interface ReferralRecordService {

    /**
     * 分页查询客户列表
     *
     * @param activityId
     * @param pageInfo
     * @return
     */
    public List<ReferralCustomer> getCustomerListByActivityId(long activityId, PageInfo pageInfo);

    /**
     * 分页查询经纪人列表
     * 
     * @param activity
     * @param pageInfo
     */
    public List<BrokerDto> getBrokerList(long activityId, PageInfo page);

    /**
     * 设置
     *
     * @param recordId
     * @param giftId
     */
    public ResultWrapper<ReferralRecord> setBrokerGift(long recordId, long giftId, long orgId);

    /**
     * 添加介绍信息
     *
     * @param record
     * @return
     */
    public ReferralCode addReferralRecord(ReferralRecord record);

    /**
     * 结算
     *
     * @param brokerPhone
     * @param month
     * @return
     */
    public void settleReferralByMonth(long activityId, String brokerPhone, String month);

    /**
     * 按月统计结算
     *
     * @param activityId
     * @param month
     * @param status
     * @param pageDto
     * @return
     */
    public CommissionListDto getCommissionListByMonth(long activityId, String month, int status, PageDto pageDto);

    /**
     * 
     * @param activityId
     * @param orgId
     * @param brokerPhone
     * @param month
     * @param status
     * @param lastId
     * @return
     */
    List<CommissionDetail> referralRecordDetail(long activityId, long orgId, String brokerPhone, String month,
        Integer status, PageInfo pageInfo);
}
