package com.baijia.tianxiao.sal.marketing.commons.utils;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.mail.Session;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Feb 24, 2016 2:25:18 PM
 * @desc :
 */
@Slf4j
public class ActivityMailSender {

    public static Mail createMail(final String email, String from, final String subject, final String content) {
        log.info("begin to create mail !");
        Mail mail = new Mail();
        from = GenericsUtils.isNullOrEmpty(from) ? ConstantEnums.MAILBOX_FROM.value() : from;
        mail.setFrom(from);
        mail.setContent(content);
        mail.addToAddress(email);
        mail.setSubject(subject);
        log.info("mail is : " + ToStringBuilder.reflectionToString(mail));
        return mail;
    }

    public static Mail addAttache(Mail mail, List<Map<String, String>> rows, String...attacheFileName) {
        try {
            String filename = null;
            if (GenericsUtils.notNullAndEmpty(attacheFileName)) {
                filename = attacheFileName[0];
            } else {
                filename = DateUtil.getStrByDate(new Date()) + ".xls";
            }

            File file = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
            if (file == null) {
                return mail;
            }
            log.info("ATTACH FILE  path is : {}", file.getAbsolutePath());
            mail.addAttachFile(file);
        } catch (Exception e) {
            log.error("error :", e);
        }
        return mail;
    }

    public static void sendMail(final String email, final Mail mail, final Boolean...needClean) {
        System.out.println("begin to send mail ");
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    System.out.println("begin to send mail !");
                    String host = (ConstantEnums.MAILBOX_SMTPSERVIER.value());
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if (GenericsUtils.notNullAndEmpty(needClean)) {
                        if (needClean[0]) {
                            mail.clean();
                        }
                    }
                }
            }
        });
    }

    public static void sendMail(final String email, final Mail mail, final String host, final String username,
        final String password, final Boolean...needClean) {
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if (GenericsUtils.notNullAndEmpty(needClean)) {
                        if (needClean[0]) {
                            mail.clean();
                        }
                    }
                }
            }
        });
    }

    public static void sendMail(final String email, final String subject, final String content, final Long activityId,
        final List<Map<String, String>> rows) {
        System.out.println("begin to send mail ");
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                File reportFile = null;
                try {
                    System.out.println("begin to send mail !");
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    System.out.println("mail is : " + ToStringBuilder.reflectionToString(mail));
                    try {
                        String filename = activityId + "_" + DateUtil.getStrByDate(new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile == null) {
                            return;
                        }
                        log.info("PARTAKE FILE  path is : {}", reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    } catch (Exception e) {
                        log.error("error :", e);
                    }
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                    throw new RuntimeException(ex);
                } finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }

}
