package com.baijia.tianxiao.sal.marketing.article.utils;

import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.utils.QRCodeUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;

import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Test;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

import javax.imageio.ImageIO;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/3/25.
 */
@Slf4j
public class QrCodeUtil {

    public static String replaceWechatImgUrl(String html) {
        if(StringUtils.isBlank(html)){
            return "";
        }
        Document document = Jsoup.parse(html);
        Elements elements = document.select("img[data-src]");
        if (elements != null && elements.size() > 0) {
            for (int i = 0; i < elements.size(); i++) {
                if (StringUtils.isNotBlank(elements.get(i).attr("data-src"))) {
                    String attr = elements.get(i).attr("data-src");
                    attr = attr.replace("http://mmbiz.qpic.cn", Config.DOMAIN + "/wechatImg");
                    log.info("[Wechat] image url=" + attr);
                    elements.get(i).attr("data-src", attr);
                }
            }
        }
        return document.toString();
    }

    /**
     * 删除二维码
     * 
     * @param html
     * @return
     */
    public static String deleteQrCodeEffecient(String html) {
        Document document = Jsoup.parse(html);
        Elements elements = document.select("img");
        if (elements != null && elements.size() > 0) {
            for (int i = elements.size() - 1; i >= 0;) {
                if (isQrCode(elements.get(i))) {
                    elements.get(i).remove();
                    int j = (i - 1);
                    if (j >= 0 && !isQrCode(elements.get(j))) {
                        break;
                    } else if (j >= 0) {
                        elements.get(j).remove();
                        i = j - 1;
                    } else {
                        i--;
                    }
                } else {
                    i--;
                }
            }
        }
        return document.toString();
    }

    /**
     * 判断某个图片节点中的Image是否是二维码
     * 
     * @param element
     * @return
     */
    public static boolean isQrCode(Element element) {
        if (StringUtils.isNotBlank(element.attr("data-src"))) {
            String attr = element.attr("data-src");
            String srcUrl = attr.trim();
            srcUrl = srcUrl.replaceAll("(.*)\\?.*", "$1");
            try {
                boolean isQrCode = qrCodeCheck(srcUrl);
                return isQrCode;
            } catch (NotFoundException e) {
                // log.warn("[ not found exception ]", e);
            } catch (ReaderException e) {
                log.warn("[ReaderException]", e.getMessage());
            } catch (Exception e) {
                log.warn("[OtherException]", e.getMessage());
            }
        }
        return false;
    }

    /**
     * 判断是否是二维码
     * 
     * @param srcUrl
     * @return
     * @throws Exception
     */
    public static boolean qrCodeCheck(String srcUrl) throws Exception {
        String text = null;
        BufferedImage bufferedImage = downImageAndReturn(srcUrl);
        try {
            text = QRCodeUtils.decode(bufferedImage);
        } catch (Exception e) {
            log.warn("exception : ", e);
        }
        return StringUtils.isNotBlank(text);
    }

    /**
     * 直接根据文件流返回图片文件对象
     * 
     * @param src
     * @return
     * @throws Exception
     */
    public static BufferedImage downImageAndReturn(String src) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(src);
        CloseableHttpResponse response = httpclient.execute(httpget);
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream input = entity.getContent();
                String ext = null;
                Header[] headers = response.getHeaders("Content-Type");
                if (GenericsUtils.notNullAndEmpty(headers)) {
                    String type = headers[0].getValue();
                    ext = getExt(type);
                }
                if (ext.equalsIgnoreCase(".gif")) {
                    return ImageUtil.getGifFirstFrame(input, 1);
                } else {
                    return ImageIO.read(input);
                }
            }
        } catch (IOException e){
            log.warn("[Article] read gif error.{}" ,e);
        }finally {
            response.close();
        }
        return null;
    }

    /**
     * 下载图片为临时文件
     * 
     * @param src
     * @return
     * @throws Exception
     */
    public static File downImageFile(String src) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(src);
        CloseableHttpResponse response = httpclient.execute(httpget);
        File file = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream input = entity.getContent();
                String ext = null;
                Header[] headers = response.getHeaders("Content-Type");
                if (GenericsUtils.notNullAndEmpty(headers)) {
                    String type = headers[0].getValue();
                    ext = getExt(type);
                }
                file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString() + ext);
                OutputStream output = new FileOutputStream(file);
                byte[] buffer = new byte[(int) entity.getContentLength()];
                IOUtils.readFully(input, buffer);
                IOUtils.write(buffer, output);
                return file;
            }
        } finally {
            response.close();
        }
        return null;
    }

    /**
     * 根据Content-type 获取到文件的类型
     * 
     * @param type
     * @return
     */
    private static String getExt(String type) {
        if (type.equalsIgnoreCase("image/gif")) {
            return ".gif";
        } else if (type.equalsIgnoreCase("image/jpeg")) {
            return ".jpeg";
        } else if (type.equalsIgnoreCase("image/png")) {
            return ".png";
        }
        return ".png";
    }

    @Test
    public void testQrCode() throws Exception {
        String url =
            "http://img.blog.csdn.net/20150504161653341?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvY2xhc3NfaG9yc2U=/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/Center";
        boolean isQrCode = qrCodeCheck(url);
        System.out.println(isQrCode);
    }

    public static void main(String[] args) throws Exception {
        // System.out.println(str);
        // System.out.println(deleteQrCode(str));
        // HttpClient httpClient = new HttpClient();
        // GetMethod get = new GetMethod(
        // "http://mp.weixin.qq.com/s?__biz=MzA5MjEwODUzNw==&mid=408589102&idx=1&sn=af3bad3e0f2b1390a68ed374a4eb6758&3rd=MzA3MDU4NTYzMw==&scene=6#rd");
        // httpClient.executeMethod(get);
        byte[] resource = HttpClientUtils.download(
            "http://img.blog.csdn.net/20150504161653341?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvY2xhc3NfaG9yc2U=/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/Center");
        String content = new String(resource, "utf-8");
        // System.out.print(content);
        long beginTime = System.currentTimeMillis();
        String deleteQrCode = deleteQrCodeEffecient(content);
        System.out.println("result is : " + deleteQrCode);
        long endTime = System.currentTimeMillis();
        System.out.print("use time : " + (endTime - beginTime));
    }
}
