package com.baijia.tianxiao.sal.marketing.activity.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityEnrollDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.marketing.activity.service.EnrollService;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsEnrollDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ResultType;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonToMap;

import com.baijia.tianxiao.sal.marketing.commons.utils.MnsUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * Created by liuxp on 16/1/11.
 */
@Service
@Slf4j
public class EnrollServiceImpl implements EnrollService {

    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private ActivityConfDao confDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private MqService mqService;

    @Override
    public List<ActivityEnrollDto> getEnrollList(long activityId, PageInfo page) {
        List<ActivityEnroll> enrolls = enrollDao.selectEnrollsByActivityId(activityId, page);

        if (enrolls == null || enrolls.size() < 1) {
            return Collections.emptyList();
        }

        List<ActivityEnrollDto> dtos = new ArrayList<>(enrolls.size());

        for (ActivityEnroll enroll : enrolls) {
            dtos.add(ActivityEnrollDto.getInstance(enroll));
        }

        return dtos;
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public ResultWrapper<Object> addEnroll(ActivityEnroll enroll) {
        ResultWrapper<Object> ret = validateActivityEnroll(enroll);

        if (ret.getRetType() == ResultType.SUCC) {
            enroll.setCreateTime(new Timestamp(new Date().getTime()));
            log.info("[Enroll] content====param:{}", enroll.getContent());
            enrollDao.insertEnroll(enroll);
            Activity activity = activityDao.getActivityById(enroll.getActivityId());
            mqService.pushMns(MnsEnrollDto.getInstance(activity, enroll), MnsUtils.getPrefix());
        }



        return ret;
    }

    private ResultWrapper<Object> validateActivityEnroll(ActivityEnroll enroll) {
        ResultWrapper<Object> ret = new ResultWrapper<Object>();

        Activity activity = activityDao.getActivityById(enroll.getActivityId());

        ActivityConf conf = confDao.getConfigByActivityId(enroll.getActivityId());

        if (activity == null || conf == null) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("该活动不存在，请输入正确的活动ID");
            return ret;
        }

        int enrolledCount = enrollDao.getEnrollCount(enroll.getActivityId());
        if (conf.getCountLimit() <= enrolledCount) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("名额已报满，请期待下次");
            return ret;
        }

        if (conf.getReportEndTime().before(new Date())) {
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("报名已结束,请期待下次");
            return ret;
        }

        Map<String,Object> map = JsonToMap.toMap(enroll.getContent());
        String mobile = (String)map.get("mobile");
        if(StringUtils.isBlank(mobile)){
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("手机号不能为空");
            return ret;
        }

        //会出现有-的情况，将手机中所有-替换调
        mobile = mobile.replaceAll("-", "");
        if(isExistedMobile(enroll.getActivityId(),mobile)){
            ret.setRetType(ResultType.FAIL);
            ret.setRetDesc("该手机号已经报名");
            return ret;
        }
        
        map.put("mobile", mobile);
        JSONObject jsonObject = JSONObject.fromObject(map);
        enroll.setContent(jsonObject.toString());
        return ret;
    }

    private boolean isExistedMobile(long activityId, String mobile) {
        log.info("[Enroll] mobile param:{}", mobile);
        ActivityEnroll enroll = enrollDao.selectEnrollByMobile(activityId, mobile);
        return enroll != null;
    }
    
    public static void main(String[] args){
        Map<String, String> map = new HashMap<>();
        map.put("name", "校长");
        JSONObject jsonObject = JSONObject.fromObject(map);
        System.out.println(jsonObject.toString());
    }
}
