/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.activity.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月22日
 * @desc
 */
@Service
@Slf4j
public class ActivityDataExportServiceImpl implements ActivityDataExportService {
    @Autowired
    ActivityDao activityDao;
    @Autowired
    ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    EnrollDao enrollDao;

    @Override
    public Map<Long, ActivityStatisticsData> getActivityData(Date startTime, Date endTime, String startDate, String curDate,
        List<Long> TianxiaoOrgIds, int way) {
        Map<Long, ActivityStatisticsData> activityDatas = new HashMap<>();
        // 查询使用发活动的机构
        List<Long> orgIds = activityDao.getExistOrgIds(TianxiaoOrgIds);

        if (orgIds == null || orgIds.size() == 0) {
            return activityDatas;
        }
        Map<Long, List<Long>> activityIdsOfOrgIdByDay =
            this.activityDao.getActivityIdByOrgIds(orgIds, startTime, endTime);

        Map<Long, List<Long>> activityIdsOfOrgId = this.activityDao.getActivityIdByOrgIds(orgIds, null, null);
        for (Long orgId : orgIds) {
            List<Long> activityIds = activityIdsOfOrgId.get(orgId);
            if (activityIds == null || activityIds.isEmpty()) {
                continue;
            }
            ActivityStatisticsData activityStaticData = new ActivityStatisticsData();
            Integer activityTotal;
            if (activityIdsOfOrgIdByDay == null || activityIdsOfOrgIdByDay.size() == 0) {
                activityTotal = 0;
            } else {
                if (GenericsUtils.isNullOrEmpty(activityIdsOfOrgIdByDay.get(orgId))) {
                    activityTotal = 0;
                } else {
                    activityTotal = activityIdsOfOrgIdByDay.get(orgId).size();

                }

            }
            Integer browseCount = 0;
            if (way == 3) {
                browseCount = this.activityAccessLogDao.getActivityAccessLogTotal(activityIds,
                    TemplateTypeCategory.COMMON_TYPE.getType());
            } else {
                browseCount = this.activityAccessLogDao.getActivityAccessLogTotalByDay(activityIds,
                    TemplateTypeCategory.COMMON_TYPE.getType(), startDate, curDate);
            }
            Integer enrollCount = this.enrollDao.getEnrollTotal(activityIds, startTime, endTime);
            activityStaticData.setActivityTotal(activityTotal);
            activityStaticData.setBrowseCount(browseCount == null ? 0 : browseCount);
            activityStaticData.setEnrollCount(enrollCount == null ? 0 : enrollCount);

            activityDatas.put(orgId, activityStaticData);
        }

        return activityDatas;
    }

}
