/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.sal.marketing.export.dto.ExportDto;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月23日
 * @desc
 */
@Data
@Slf4j
public class ActivityStatisticsData extends ActivityBaseInfo {
    private int activityTotal;

    public static ExportDto getExportDtoInstance(ActivityStatisticsData activityStaticData) {
        ExportDto export = new ExportDto();
        export.setActivityTotal(activityStaticData.getActivityTotal()); // 活动总数
        export.setActivityAccessTotal(activityStaticData.getBrowseCount());
        export.setActivityEnrollTotal(activityStaticData.getEnrollCount());

        return export;
    }

    public static void setExportDto(ActivityStatisticsData activityStaticData, ExportDto exportDto) {
        exportDto.setActivityTotal(activityStaticData.getActivityTotal()); // 活动总数
        exportDto.setActivityAccessTotal(activityStaticData.getBrowseCount());
        exportDto.setActivityEnrollTotal(activityStaticData.getEnrollCount());
    }

}
