/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.vote.dto;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import java.util.Date;

public class VoteListDto
extends VoteStatistics {
    private String name;
    private Long updateTime;
    private int status;
    private int templateId;

    public static VoteListDto getInstance(VoteInfo info) {
        VoteListDto dto = new VoteListDto();
        dto.setActivityId(info.getActivityId());
        dto.setName(info.getName());
        dto.setUpdateTime(info.getUpdateTime().getTime());
        if (info.getStatus().intValue() == ActivityStatus.CLOSED.getCode()) {
            dto.setStatus(info.getStatus());
        } else if (info.getStartTime().after(new Date())) {
            dto.setStatus(ActivityStatus.UN_START.getCode());
        } else if (info.getEndTime().before(new Date())) {
            dto.setStatus(ActivityStatus.END.getCode());
        } else {
            dto.setStatus(ActivityStatus.RUNNING.getCode());
        }
        dto.setTemplateId(info.getTemplateId());
        return dto;
    }

    public String getName() {
        return this.name;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public int getStatus() {
        return this.status;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoteListDto)) {
            return false;
        }
        VoteListDto other = (VoteListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        return this.getTemplateId() == other.getTemplateId();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VoteListDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        result = result * 59 + this.getStatus();
        result = result * 59 + this.getTemplateId();
        return result;
    }

    @Override
    public String toString() {
        return "VoteListDto(name=" + this.getName() + ", updateTime=" + this.getUpdateTime() + ", status=" + this.getStatus() + ", templateId=" + this.getTemplateId() + ")";
    }
}

