/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Mail {
    private String from;
    private StringBuilder toAddress = new StringBuilder();
    private StringBuilder ccAddress = new StringBuilder();
    private StringBuilder bccAddress = new StringBuilder();
    private String subject;
    private String content;
    private List<AttachBean> attachList = new ArrayList<AttachBean>();
    private List<File> attachFiles = new ArrayList<File>();

    public Mail() {
    }

    public Mail(String from, String to) {
        this(from, to, null, null);
    }

    public Mail(String from, String to, String subject, String content) {
        this.from = from;
        this.toAddress.append(to);
        this.subject = subject;
        this.content = content;
    }

    public List<File> getAttachFiles() {
        return this.attachFiles;
    }

    public void addAttachFile(File file) {
        if (file.exists()) {
            AttachBean fileAttach = new AttachBean();
            fileAttach.setCid(file.getName());
            fileAttach.setFile(file);
            fileAttach.setFileName(file.getName());
            this.addAttach(fileAttach);
            this.attachFiles.add(file);
        }
    }

    public void clean() {
        if (GenericsUtils.notNullAndEmpty(this.attachFiles)) {
            for (File file : this.attachFiles) {
                file.delete();
            }
        }
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getToAddress() {
        return this.toAddress.toString();
    }

    public String getCcAddress() {
        return this.ccAddress.toString();
    }

    public String getBccAddress() {
        return this.bccAddress.toString();
    }

    public void addToAddress(String to) {
        if (this.toAddress.length() > 0) {
            this.toAddress.append(",");
        }
        this.toAddress.append(to);
    }

    public void addCcAddress(String cc) {
        if (this.ccAddress.length() > 0) {
            this.ccAddress.append(",");
        }
        this.ccAddress.append(cc);
    }

    public void addBccAddress(String bcc) {
        if (this.bccAddress.length() > 0) {
            this.bccAddress.append(",");
        }
        this.bccAddress.append(bcc);
    }

    public void addAttach(AttachBean attachBean) {
        this.attachList.add(attachBean);
    }

    public List<AttachBean> getAttachs() {
        return this.attachList;
    }
}

