/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelUtil;
import com.baijia.tianxiao.sal.marketing.export.dto.ExportVoteDetail;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoResponse;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteListDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteOptionDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteRenderDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteStatistics;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteOptionService;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteService;
import com.baijia.tianxiao.sal.marketing.vote.utils.VoteOptionUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VoteServiceImpl
implements VoteService {
    private static final Logger log = LoggerFactory.getLogger(VoteServiceImpl.class);
    public static final int VOTE_ACTIVITY_CATEGORY = TemplateTypeCategory.VOTE_TYPE.getType();
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private VoteOptionDao optionDao;
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private VoteOptionService voteOptionService;

    @Override
    public Map<Long, ActivityUser> getVoteResultByWechatOpenId(Long activityId, String wechatOpenId, int isVotedByDay) {
        String date = null;
        if (isVotedByDay == 1) {
            date = DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd");
        }
        if (StringUtils.isBlank((CharSequence)wechatOpenId)) {
            return Collections.EMPTY_MAP;
        }
        List users = this.activityUserDao.selectActivityUsers(wechatOpenId, date, activityId, Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getType()));
        if (users != null && users.size() > 0) {
            Map extractMap = CollectionUtils.extractMap((Collection)users, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, ActivityUser>(){

                public Long extract(ActivityUser paramE) {
                    return paramE.getOptionsId();
                }
            });
            return extractMap;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public VoteInfoResponse modifyVoteInfo(VoteInfoRequest request, Long orgId) {
        VoteInfo info = request.getVoteInfo();
        info.setUpdateTime(new Timestamp(new Date().getTime()));
        this.voteInfoDao.updateVoteActivity(info);
        List<VoteOption> optionList = VoteOptionUtil.parseOptionList(request);
        if (optionList != null) {
            ArrayList<Long> ids = new ArrayList<Long>(optionList.size());
            ArrayList<VoteOption> newOptions = new ArrayList<VoteOption>();
            for (VoteOption option : optionList) {
                log.info("[Vote] OptionId=" + option.getId());
                if (option.getId() != null && option.getId() != 0L) {
                    ids.add(option.getId());
                    option.setUpdateTime(new Date());
                    option.setStatus(Integer.valueOf(1));
                    this.optionDao.updateVoteOption(option);
                    continue;
                }
                option.setCreateTime(new Date());
                option.setActivityId(info.getActivityId());
                option.setUpdateTime(new Date());
                option.setStatus(Integer.valueOf(1));
                newOptions.add(option);
            }
            log.info("[Ids are : ] {} ", ids);
            this.optionDao.deleteVoteOptions(request.getActivityId(), ids);
            log.info("[Vote] add new option:" + newOptions);
            this.optionDao.batchInsertVoteOptions(newOptions);
        }
        VoteInfoResponse response = VoteInfoResponse.getVoteInfoResponse(info);
        response.setVoteOptions(this.voteOptionService.getOptionList(info.getActivityId()));
        return response;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void modifyVoteInfoStatus(Long voteId, Long orgId, int status) {
        VoteInfo info = this.voteInfoDao.selectVoteInfo(voteId, orgId);
        if (info != null) {
            VoteInfo updateInfo = new VoteInfo();
            updateInfo.setActivityId(voteId);
            updateInfo.setStatus(Integer.valueOf(status));
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            this.voteInfoDao.updateVoteActivity(updateInfo);
        } else {
            log.warn("[Vote] vote is not exist.voteId=" + voteId);
        }
    }

    @Override
    public VoteInfoResponse getVoteInfoById(long voteId, long orgId) {
        VoteInfo vote = this.voteInfoDao.selectVoteInfo(Long.valueOf(voteId), Long.valueOf(orgId));
        VoteInfoResponse response = VoteInfoResponse.getVoteInfoResponse(vote);
        response.setVoteOptions(this.voteOptionService.getOptionList(voteId));
        ArrayList<VoteInfoResponse> list = new ArrayList<VoteInfoResponse>(1);
        list.add(response);
        this.setStatistics(list);
        return response;
    }

    private void setStatistics(List<? extends VoteStatistics> voteBaseInfo) {
        if (GenericsUtils.isNullOrEmpty(voteBaseInfo)) {
            return;
        }
        Set<Long> activityIds = this.getIds(voteBaseInfo);
        Map accessUserCountResult = this.activityAccessLogDao.selectTotalByActivityId(new ArrayList<Long>(activityIds), VOTE_ACTIVITY_CATEGORY);
        Map<Long, Integer> partakeUserCountResult = this.getUserCount(activityIds);
        Map voteUserResult = this.activityUserDao.statisticalVotes(new ArrayList<Long>(activityIds), Integer.valueOf(VOTE_ACTIVITY_CATEGORY));
        for (VoteStatistics voteStatistics : voteBaseInfo) {
            Integer browseCount = (Integer)accessUserCountResult.get(voteStatistics.getActivityId());
            Integer partakeCount = partakeUserCountResult.get(voteStatistics.getActivityId());
            voteStatistics.setBrowseCount(browseCount == null ? 0 : browseCount);
            voteStatistics.setUserCount(partakeCount == null ? 0 : partakeCount);
            Map votedCountResult = (Map)voteUserResult.get(voteStatistics.getActivityId());
            List options = this.optionDao.selectVoteOptionsByVoteId(voteStatistics.getActivityId());
            this.setVoteCount(voteStatistics, options, votedCountResult);
            log.info("activity_id : {} , browseCount : {} , partakeCount : {} , votedCount : {} ", new Object[]{voteStatistics.getActivityId(), browseCount, partakeCount, voteStatistics.getVoteCount()});
        }
    }

    private Set<Long> getIds(List<? extends VoteStatistics> statisticsList) {
        HashSet<Long> activityIds = new HashSet<Long>();
        for (VoteStatistics voteStatistics : statisticsList) {
            activityIds.add(voteStatistics.getActivityId());
        }
        return activityIds;
    }

    private Map<Long, Integer> getUserCount(Set<Long> activityIds) {
        HashMap<Long, Integer> retMap = new HashMap<Long, Integer>();
        for (Long activityId : activityIds) {
            Integer count = 0;
            List list = this.activityUserDao.selectDairyCountStatisticsWithSingle(activityId.longValue(), VOTE_ACTIVITY_CATEGORY);
            if (GenericsUtils.notNullAndEmpty((Object)list)) {
                for (DairyCountStatistics statistics : list) {
                    count = count + statistics.getCount();
                }
            }
            retMap.put(activityId, count);
        }
        return retMap;
    }

    private int setVoteCount(VoteStatistics vbi, List<VoteOption> options, Map<Long, Integer> votedCountResult) {
        List optionIds = CollectionUtils.extractList(options, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, VoteOption>(){

            public Long extract(VoteOption arg0) {
                return arg0.getId();
            }
        });
        int votedCount = 0;
        if (GenericsUtils.notNullAndEmpty(votedCountResult)) {
            for (Map.Entry<Long, Integer> entry : votedCountResult.entrySet()) {
                Long optionId = entry.getKey();
                if (!optionIds.contains(optionId) || entry.getValue() == 0) continue;
                votedCount += entry.getValue().intValue();
            }
        }
        vbi.setVoteCount(votedCount);
        return votedCount;
    }

    @Override
    public VoteRenderDto getVoteRenderDtoById(long voteId, String wechatOpenId) {
        VoteInfo info = this.voteInfoDao.selectVoteInfo(Long.valueOf(voteId), null);
        VoteRenderDto vote = VoteRenderDto.getInstance(info);
        vote.setVoteOptions(this.voteOptionService.getOptionList(voteId));
        if (StringUtils.isBlank((CharSequence)vote.getTopPic())) {
            vote.setTopPic("http://img.gsxservice.com/7015516_q4n861gv.jpg");
        }
        Map<Long, ActivityUser> voteResultMap = this.getVoteResultByWechatOpenId(voteId, wechatOpenId, info.getIsVotedByDay());
        log.info("[Vote] Vote status=" + voteResultMap);
        if (vote.getVoteOptions() != null) {
            Map voteUserResult = this.activityUserDao.statisticalVotes(Arrays.asList(voteId), Integer.valueOf(VOTE_ACTIVITY_CATEGORY));
            Map optionVoteCounts = null;
            optionVoteCounts = GenericsUtils.notNullAndEmpty((Object)voteUserResult) ? (Map)voteUserResult.get(voteId) : Collections.emptyMap();
            for (VoteOptionDto dto : vote.getVoteOptions()) {
                Integer count = (Integer)optionVoteCounts.get(dto.getId());
                count = count == null ? 0 : count;
                dto.setVoteNum(count);
                if (voteResultMap.get(dto.getId()) == null) {
                    if (voteResultMap.size() >= info.getCountLimit()) {
                        dto.setStatus(0);
                        continue;
                    }
                    dto.setStatus(1);
                    continue;
                }
                dto.setStatus(0);
            }
        }
        if (info.getIsRankSort() != null && info.getIsRankSort() == 1) {
            Collections.sort(vote.getVoteOptions(), new Comparator<VoteOptionDto>(){

                @Override
                public int compare(VoteOptionDto o1, VoteOptionDto o2) {
                    int num1 = o1.getVoteNum() == null ? 0 : o1.getVoteNum();
                    int num2 = o2.getVoteNum() == null ? 0 : o2.getVoteNum();
                    return num2 - num1;
                }
            });
        }
        return vote;
    }

    @Override
    public List<VoteListDto> getVoteList(int status, long orgId, PageInfo pageInfo) {
        List infoList = this.voteInfoDao.selectVoteInfoList(Integer.valueOf(status), Long.valueOf(orgId), pageInfo);
        if (infoList != null) {
            ArrayList<VoteListDto> dtos = new ArrayList<VoteListDto>(infoList.size());
            for (VoteInfo info : infoList) {
                dtos.add(VoteListDto.getInstance(info));
            }
            this.setStatistics(dtos);
            return dtos;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportVoteDetail(long activityId) {
        File file;
        log.info("[ExportVote] start---------");
        long start = System.currentTimeMillis();
        List users = this.activityUserDao.selectAllUsers(activityId, VOTE_ACTIVITY_CATEGORY);
        VoteInfo info = this.voteInfoDao.selectVoteInfo(Long.valueOf(activityId), null);
        List optionList = this.optionDao.selectVoteOptionsByVoteId(Long.valueOf(activityId));
        Map map = CollectionUtils.extractMap((Collection)optionList, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, VoteOption>(){

            public Long extract(VoteOption option) {
                return option.getId();
            }
        });
        ArrayList<ExportVoteDetail> resultList = new ArrayList<ExportVoteDetail>(users.size());
        if (users != null) {
            for (ActivityUser user : users) {
                ExportVoteDetail detail = new ExportVoteDetail();
                detail.setVoteDate(user.getDoneDate());
                detail.setWechatOpenId(user.getWechatOpenId());
                detail.setActivityName(info.getName());
                detail.setOptionName(((VoteOption)map.get(user.getOptionsId())).getName());
                detail.setIntroduction(((VoteOption)map.get(user.getOptionsId())).getIntroduction());
                resultList.add(detail);
            }
        }
        if ((file = new File("vote_detail_" + activityId + ".xls")).exists()) {
            file.delete();
        }
        FileOutputStream fis = null;
        try {
            file.createNewFile();
            fis = new FileOutputStream(file);
            this.exportActivityList(resultList, fis);
            fis.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("Path=" + file.getAbsolutePath());
        ExcelMailSender.sendMail("liuxiaopeng@baijiahulian.com", "\u6295\u7968\u660e\u7ec6", "", new File[]{file});
        log.info("[ExportVote] End ---------.Cost = " + (System.currentTimeMillis() - start));
    }

    public void exportActivityList(List<ExportVoteDetail> list, OutputStream out) {
        int i;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        String[] TITLE = new String[]{"\u6d3b\u52a8\u540d\u79f0", "\u6295\u7968\u9879\u76ee\u540d\u79f0", "\u6295\u7968\u9009\u9879\u7b80\u4ecb", "\u6295\u7968\u65f6\u95f4", "\u5fae\u4fe1id"};
        for (int i2 = 0; i2 < TITLE.length; ++i2) {
            sheet.setColumnWidth(i2, 5120);
        }
        HSSFRow row = sheet.createRow(0);
        for (i = 0; i < TITLE.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(TITLE[i]);
        }
        if (list != null && list.size() > 0) {
            for (i = 0; i < list.size(); ++i) {
                ExportVoteDetail info = list.get(i);
                row = sheet.createRow(i + 1);
                ExcelUtil.createCell(row, 0, info.getActivityName());
                ExcelUtil.createCell(row, 1, info.getOptionName());
                ExcelUtil.createCell(row, 2, info.getIntroduction());
                ExcelUtil.createCell(row, 3, info.getVoteDate());
                ExcelUtil.createCell(row, 4, info.getWechatOpenId());
            }
        } else {
            log.warn("[Export] No Activity.");
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

