/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.service.impl;

import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralBaseInfo;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralRequest;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralResponse;
import com.baijia.tianxiao.sal.marketing.referral.service.GiftService;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralService;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.util.GenericsUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReferralServiceImpl
implements ReferralService {
    private static final Logger log = LoggerFactory.getLogger(ReferralServiceImpl.class);
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private GiftService giftService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private GiftInfoDao giftInfoDao;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ReferralResponse addActivity(ReferralRequest request) {
        ReferralInfo ri = request.buildPo();
        log.info("find referralInfo :{}", (Object)ri);
        if (ri == null) {
            return null;
        }
        ri.setTemplateTypeId(Integer.valueOf(301));
        ri.setStatus(Integer.valueOf(1));
        if (GenericsUtils.isNullOrEmpty((Object)ri.getTopPicUrl())) {
            ri.setTopPicUrl(ConstantEnums.REFERRAL_DEFAULT_TOP_PIC.value());
        }
        ri.setTemplateTypeId(Integer.valueOf(301));
        Long activityId = this.referralInfoDao.saveReferral(ri);
        log.info("save success and ret activityId is :{}", (Object)activityId);
        List<GiftInfo> gifts = request.buildGiftInfos(activityId);
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId()));
        log.info("templateUserCount is update success");
        this.giftService.batchAdd(activityId, gifts);
        request.setActivityId(activityId);
        return this.findDetail(request);
    }

    @Override
    public ReferralResponse findDetail(ReferralRequest request) {
        ReferralInfo info = this.referralInfoDao.getReferralInfo(request.getActivityId(), request.getOrgId());
        if (info == null) {
            return null;
        }
        List<GiftInfo> gifts = this.giftService.findGifts(request.getActivityId());
        ReferralResponse response = ReferralResponse.buildResponse(info, gifts);
        this.statistics(Arrays.asList(response));
        return response;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public boolean modifyStatus(ReferralRequest request) {
        ReferralInfo info = this.referralInfoDao.getReferralInfo(request.getActivityId(), request.getOrgId());
        if (info != null) {
            info.setStatus(request.getStatus());
            info.setUpdateTime(new Timestamp(new Date().getTime()));
            this.referralInfoDao.updateReferral(info);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ReferralResponse modifyActivity(ReferralRequest request) {
        ReferralInfo ri = request.buildPo();
        Long activityId = request.getActivityId();
        ri.setOrgId(request.getOrgId());
        Timestamp time = new Timestamp(new Date().getTime());
        ri.setUpdateTime(time);
        List<GiftInfo> gifts = request.buildGiftInfos(new Long[0]);
        HashSet<Long> existsIds = new HashSet<Long>();
        if (GenericsUtils.notNullAndEmpty(gifts)) {
            ArrayList<GiftInfo> newGifts = new ArrayList<GiftInfo>();
            for (GiftInfo gi : gifts) {
                Long id = gi.getId();
                if (id == null || id == 0L) {
                    gi.setActivityId(activityId);
                    gi.setCreateTime(time);
                    gi.setStatus(Integer.valueOf(1));
                    gi.setUpdateTime(time);
                    newGifts.add(gi);
                    continue;
                }
                existsIds.add(id);
                gi.setUpdateTime(time);
                gi.setStatus(Integer.valueOf(1));
                this.giftInfoDao.updateGifts(Arrays.asList(gi));
            }
            log.info("existsIds are : {} ", existsIds);
            log.info("new giftInfos are :{} ", newGifts);
            this.giftService.deleteGifts(activityId, new ArrayList<Long>(existsIds));
            this.giftService.batchAdd(activityId, newGifts);
        }
        this.referralInfoDao.updateReferral(ri);
        return this.findDetail(request);
    }

    @Override
    public List<ReferralBaseInfo> listActivitys(ReferralRequest request, PageInfo pageInfo) {
        Long orgId;
        Integer status = request.getStatus();
        List listReferrals = this.referralInfoDao.listReferrals(status, orgId = request.getOrgId(), pageInfo);
        if (GenericsUtils.isNullOrEmpty((Object)listReferrals)) {
            return Collections.emptyList();
        }
        ArrayList<ReferralBaseInfo> rbis = new ArrayList<ReferralBaseInfo>(listReferrals.size());
        for (ReferralInfo ri : listReferrals) {
            ReferralBaseInfo rbi = ReferralBaseInfo.buildDto(ri);
            rbis.add(rbi);
        }
        this.statistics(rbis);
        return rbis;
    }

    private void statistics(List<ReferralBaseInfo> rbis) {
        if (GenericsUtils.isNullOrEmpty(rbis)) {
            return;
        }
        this.referralStatisticsService.setStatistics(rbis);
    }
}

