/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.draw.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.sal.draw.service.ActivityUserService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityUserServiceImpl
implements ActivityUserService {
    @Autowired
    private ActivityUserDao activityUserDao;
    @Autowired
    private DrawActivityDao drawActivityDao;

    @Override
    public void addActivityUser(ActivityUser activityUser) {
        this.activityUserDao.insertActivityUser(activityUser);
    }

    @Override
    public List<DairyCountStatistics> getActivityUserStatistics(long activityId, long orgId) {
        List list = this.activityUserDao.selectDairyCountStatistics(activityId);
        Map statisticsMap = CollectionUtils.extractMap((Collection)list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, DairyCountStatistics>(){

            public String extract(DairyCountStatistics dairyCountStatistics) {
                return dairyCountStatistics.getDate();
            }
        });
        DrawInfo drawInfo = this.drawActivityDao.getDrawInfoDetail(Long.valueOf(activityId), Long.valueOf(orgId));
        if (drawInfo == null) {
            return Collections.emptyList();
        }
        Date endDate = new Date(Math.min(new Date().getTime(), drawInfo.getEndTime().getTime()));
        Timestamp startDate = drawInfo.getStartTime();
        List<DairyCountStatistics> ret = this.initStatistics(startDate, endDate);
        for (DairyCountStatistics statistics : ret) {
            DairyCountStatistics exist = (DairyCountStatistics)statisticsMap.get(statistics.getDate());
            if (exist == null) continue;
            statistics.setCount(exist.getCount());
        }
        return ret;
    }

    private List<DairyCountStatistics> initStatistics(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<DairyCountStatistics> statisticsList = new ArrayList<DairyCountStatistics>();
        Calendar start = Calendar.getInstance();
        start.setTime(DateUtil.getStartOfDay((Date)startTime));
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        end.setTime(DateUtil.getStartOfDay((Date)endTime));
        while (start.compareTo(end) <= 0) {
            statisticsList.add(new DairyCountStatistics(sdf.format(end.getTime()), 0));
            end.add(5, -1);
        }
        return statisticsList;
    }
}

