/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.draw.dto;

import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class DrawCacheDto
implements Serializable {
    private static final long serialVersionUID = -7500214170704502841L;
    private Long startTime;
    private Long endTime;
    private int limitCount;
    private int baseNum;
    private Long orgId;
    private int templateId;
    private int status = 1;
    private PrizeInfo[] prizes;
    private int[] probabilities;

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public int getBaseNum() {
        return this.baseNum;
    }

    public void setBaseNum(int baseNum) {
        this.baseNum = baseNum;
    }

    public PrizeInfo[] getPrizes() {
        return this.prizes;
    }

    public void setPrizes(PrizeInfo[] prizes) {
        this.prizes = prizes;
    }

    public int[] getProbabilities() {
        return this.probabilities;
    }

    public void setProbabilities(int[] probabilities) {
        this.probabilities = probabilities;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static DrawCacheDto getInstance(DrawInfo drawInfo, List<PrizeInfo> prizeInfos) {
        DrawCacheDto dto = new DrawCacheDto();
        dto.setStartTime(drawInfo.getStartTime().getTime());
        dto.setEndTime(drawInfo.getEndTime().getTime());
        dto.setLimitCount(drawInfo.getCountLimit());
        dto.setBaseNum(DrawCacheDto.getBase(prizeInfos));
        dto.setTemplateId(drawInfo.getTemplateId());
        dto.setOrgId(drawInfo.getOrgId());
        dto.setStatus(drawInfo.getStatus());
        PrizeInfo[] prizes = new PrizeInfo[prizeInfos.size()];
        int[] probabilities = new int[prizeInfos.size()];
        for (int i = 0; i < prizeInfos.size(); ++i) {
            prizes[i] = prizeInfos.get(i);
            probabilities[i] = prizes[i].getProbability().multiply(new BigDecimal(dto.getBaseNum())).intValue();
        }
        dto.setProbabilities(probabilities);
        dto.setPrizes(prizes);
        return dto;
    }

    private static int getBase(List<PrizeInfo> prizeInfos) {
        int max = 1;
        for (PrizeInfo prize : prizeInfos) {
            int length;
            String str = prize.getProbability().toString();
            int index = str.indexOf(".");
            if (index != -1) {
                str = str.substring(index);
            }
            if ((length = str.length()) <= max) continue;
            max = length;
        }
        return (int)Math.pow(10.0, max - 1);
    }

    public static void main(String[] args) {
        ArrayList<PrizeInfo> prizeInfos = new ArrayList<PrizeInfo>();
        PrizeInfo info = new PrizeInfo();
        info.setProbability(new BigDecimal("1"));
        prizeInfos.add(info);
        System.out.println(DrawCacheDto.getBase(prizeInfos));
    }
}

