/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sal.activity.dto.ActivityBaseInfo;
import com.baijia.tianxiao.sal.activity.dto.ActivityConfigDto;
import com.baijia.tianxiao.sal.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.activity.dto.ActivityEnrollDto;
import com.baijia.tianxiao.sal.activity.dto.ActivityRenderDto;
import com.baijia.tianxiao.sal.activity.dto.ActivityRequest;
import com.baijia.tianxiao.sal.activity.dto.ActivitySearchRequest;
import com.baijia.tianxiao.sal.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.activity.service.ActivityService;
import com.baijia.tianxiao.sal.activity.service.EnrollService;
import com.baijia.tianxiao.sal.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.commons.enums.EmailType;
import com.baijia.tianxiao.sal.commons.enums.ResultType;
import com.baijia.tianxiao.sal.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.commons.service.ActivityAccessLogService;
import com.baijia.tianxiao.sal.commons.service.RedisService;
import com.baijia.tianxiao.sal.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.commons.utils.CsvUtils;
import com.baijia.tianxiao.sal.commons.utils.Mail;
import com.baijia.tianxiao.sal.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.commons.utils.MailUtils;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.Session;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityServiceImpl
implements ActivityService {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;
    @Autowired
    private EnrollService enrollService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private EnrollDao enrollDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActivityAccessLogService accessLogService;

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ActivityDetailDto saveOrgActivity(ActivitySearchRequest request, Integer orgId) {
        Activity activity = this.construct(request, orgId);
        activity.setSwitcher(Integer.valueOf(1));
        Long aId = this.activityDao.saveActivity(activity);
        activity.setId(aId);
        ActivityConf saveActivityConf = this.toActivityConf(request.getConfig());
        saveActivityConf.setActivityId(aId);
        saveActivityConf.setOrgId(orgId);
        this.activityConfDao.saveActivityConf(saveActivityConf);
        ActivitySearchRequest searchRequest = new ActivitySearchRequest();
        searchRequest.setId(aId);
        searchRequest.setOrgId(orgId.longValue());
        this.templateDao.updateTemplateUseCount(Long.valueOf(request.getTemplateId().longValue()));
        return this.getActivityDetail(searchRequest);
    }

    @Override
    public List<ActivityBaseInfo> getActivitiesByOrgId(ActivitySearchRequest searchRequest) {
        List activities = this.activityDao.listActivities(searchRequest.getStatus(), searchRequest.getId(), Integer.valueOf(searchRequest.getOrgId().intValue()), searchRequest.getPageDto());
        if (GenericsUtils.isNullOrEmpty((Object)searchRequest)) {
            return Collections.emptyList();
        }
        HashSet<Long> activityIds = new HashSet<Long>();
        ArrayList<ActivityBaseInfo> baseInfoList = new ArrayList<ActivityBaseInfo>();
        for (Activity activity : activities) {
            activityIds.add(activity.getId());
        }
        Map map = this.activityConfDao.getConfigMapByActivityIds(activityIds);
        for (Activity activity : activities) {
            ActivityConf conf = (ActivityConf)map.get(activity.getId());
            ActivityBaseInfo info = ActivityBaseInfo.getInstance(activity, conf);
            int enrollCount = this.enrollDao.getEnrollCount(activity.getId().longValue());
            info.setEnrollCount(enrollCount);
            baseInfoList.add(info);
        }
        return baseInfoList;
    }

    private ActivityConf toActivityConf(ActivityConfigDto config) {
        ActivityConf tempConfig = new ActivityConf();
        tempConfig.setAddress(config.getAddress());
        tempConfig.setAreaId(config.getAreaId());
        tempConfig.setCountLimit(config.getCountLimit());
        tempConfig.setDisplay(Integer.valueOf(config.getDisplay()));
        tempConfig.setLatitude(config.getLatitude());
        tempConfig.setLongitude(config.getLongitude());
        tempConfig.setCustomConf(config.getCustomConf());
        tempConfig.setStartTime(this.getTime(config.getStartTime()));
        tempConfig.setEndTime(this.getTime(config.getEndTime()));
        tempConfig.setReportEndTime(this.getTime(config.getEnrollDeadline()));
        tempConfig.setTemplateTypeId(config.getTemplateTypeId());
        tempConfig.setTemplateId(config.getTemplateId());
        return tempConfig;
    }

    private Timestamp getTime(Long time) {
        if (time == null) {
            return null;
        }
        return new Timestamp(time);
    }

    private Activity construct(ActivitySearchRequest request, Integer orgId) {
        Activity activity = new Activity();
        activity.setOrgId(orgId);
        activity.setAuditstatus(Integer.valueOf(AuditStatus.PASS.getValue()));
        activity.setBbType(ActivityRequest.BB_TYPE);
        activity.setContent(request.getContent());
        Date date = new Date();
        activity.setCreateTime(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        activity.setcType(ActivityRequest.C_TYPE);
        activity.setStorageId(Long.valueOf(-1L));
        activity.setrType(Integer.valueOf(-1));
        activity.setSync(Integer.valueOf(-1));
        activity.setTitle(request.getName());
        activity.setStick(Integer.valueOf(1));
        activity.setCourseNumber(Long.valueOf(-1L));
        activity.setSupportNum(Integer.valueOf(0));
        activity.setSwitcher(request.getStatus());
        return activity;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void deleteActivity(ActivitySearchRequest searchRequest) {
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), searchRequest.getOrgId());
        if (activity != null) {
            activity.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
            activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(activity);
        } else {
            this.logger.info("");
        }
    }

    @Override
    public ActivityDetailDto getActivityDetail(ActivitySearchRequest searchRequest) {
        Long orgId = searchRequest.getOrgId();
        if (orgId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), orgId);
        this.logger.info("find activity {}", (Object)activity);
        if (activity == null) {
            return null;
        }
        Map confMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(searchRequest.getId()));
        int enrollCount = this.enrollDao.getEnrollCount(activity.getId().longValue());
        this.logger.info("confMap is :{}", (Object)confMap);
        if (confMap != null) {
            this.logger.info("confMap2 is :{}", (Object)confMap);
            if (confMap.get(searchRequest.getId()) != null) {
                this.logger.info("build response with activity and acitvity'conf {} , {} ", (Object)activity, confMap.get(searchRequest.getId()));
                ActivityDetailDto buildResponse = ActivityDetailDto.buildResponse(activity, (ActivityConf)confMap.get(searchRequest.getId()));
                buildResponse.setEnrollCount(enrollCount);
                return buildResponse;
            }
            this.logger.info("not find any conf ");
            ActivityDetailDto buildResponse = ActivityDetailDto.buildResponse(activity);
            buildResponse.setCustomConf(new Object());
            buildResponse.setEnrollCount(enrollCount);
            return buildResponse;
        }
        return null;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public ActivityDetailDto update(ActivitySearchRequest searchRequest) {
        Long orgId = searchRequest.getOrgId();
        if (orgId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(searchRequest.getId(), orgId);
        if (activity != null) {
            Activity updateActivity = this.construct(searchRequest, activity.getOrgId());
            updateActivity.setId(activity.getId());
            updateActivity.setOrgId(activity.getOrgId());
            updateActivity.setSupportNum(activity.getSupportNum());
            updateActivity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(updateActivity);
            ActivityConfigDto configDto = searchRequest.getConfig();
            configDto.setDisplay(searchRequest.getStatus() == null ? 1 : searchRequest.getStatus());
            ActivityConf newConf = this.toActivityConf(configDto);
            ActivityConf sourceConf = this.activityConfDao.getConfigByActivityId(activity.getId().longValue());
            if (sourceConf == null) {
                this.logger.error("[ActivityConf] conf is not exist.activityId = " + activity.getId());
                return null;
            }
            newConf.setId(sourceConf.getId());
            if (newConf.getStartTime() == null) {
                newConf.setStartTime(sourceConf.getStartTime());
            }
            this.activityConfDao.updateActivityConf(newConf);
            if (searchRequest.getTemplateId() != null) {
                this.templateDao.updateTemplateUseCount(Long.valueOf(searchRequest.getTemplateId().longValue()));
            }
            return this.getActivityDetail(searchRequest);
        }
        return null;
    }

    @Override
    public ResultWrapper<String> sendEmail(ActivitySearchRequest request) {
        this.logger.info(" begin to send mail ");
        Long orgId = request.getOrgId();
        Long activityId = request.getId();
        ResultWrapper<String> rr = new ResultWrapper<String>();
        rr.setRetType(ResultType.FAIL);
        rr.setRetDesc("\u53c2\u6570\u5f02\u5e38");
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            this.logger.info("can not find an org with org_ID {}", (Object)orgId);
            return rr;
        }
        final String orgName = simple.getShortName();
        final ActivityDetailDto activityDetail = this.getActivityDetail(request);
        if (activityDetail == null) {
            this.logger.info("can not find activityDetial with id : {} ", (Object)request.getId());
            return rr;
        }
        final List<ActivityEnrollDto> enrollList = this.enrollService.getEnrollList(request.getId(), null);
        if (GenericsUtils.isNullOrEmpty(enrollList)) {
            this.logger.info(" enroll is empty  ");
            return rr;
        }
        this.logger.info("can send mail ");
        boolean isNotLimited = this.redisService.addOrgEmailCount(orgId, activityId, activityDetail.getTemplateTypeId(), EmailType.ACCESS);
        if (!isNotLimited) {
            this.logger.info("\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u53d1");
            return ResultWrapper.getInstance(false).setRetDesc("\u4eca\u65e5\u5df2\u53d1\u9001" + ConstantEnums.EMAIL_COUNT_LIMIT.value() + "\u6b21\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5");
        }
        final String email = request.getEmail();
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File csvFile = null;
                try {
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    String subject = ConstantEnums.MAILBOX_SUBJECT.value();
                    String content = ConstantEnums.MAILBOX_CONTENT.value();
                    content = content.replace("{#ORG_NAME#}", orgName);
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    CsvUtils.CsvContent csvContent = ActivityServiceImpl.this.getCsvFileContent(activityDetail, enrollList);
                    try {
                        String filename = activityDetail.getId() + "_" + DateUtil.getStrByDate((Date)new Date()) + ".csv";
                        csvFile = CsvUtils.writerToCsvFile(null, csvContent, filename);
                        if (csvFile == null) {
                            ActivityServiceImpl.this.logger.info("csvFile is null ");
                        }
                        ActivityServiceImpl.this.logger.info("csvFile path is : {}", (Object)csvFile.getAbsolutePath());
                        if (csvFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(csvFile.getName());
                            fileAttach.setFile(csvFile);
                            fileAttach.setFileName(csvFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        ActivityServiceImpl.this.logger.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    ActivityServiceImpl.this.logger.info("send successful");
                }
                catch (Exception ex) {
                    ActivityServiceImpl.this.logger.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (csvFile != null) {
                        csvFile.delete();
                    }
                }
            }
        });
        return ResultWrapper.getInstance(true).setRetDesc("\u53d1\u9001\u6210\u529f");
    }

    private CsvUtils.CsvContent getCsvFileContent(ActivityDetailDto activityDetail, List<ActivityEnrollDto> enrollList) {
        String activityName = activityDetail.getName();
        CsvUtils.CsvContent csvContent = new CsvUtils.CsvContent();
        String headRow = "\u6d3b\u52a8\u540d\u79f0:" + activityName;
        csvContent.addRowBean(CsvUtils.RowBean.createRowType(headRow));
        String[] heads = "\u59d3\u540d,\u7535\u8bdd,\u5176\u4ed6,\u62a5\u540d\u65f6\u95f4".split(",");
        ArrayList<String> rowLists = new ArrayList<String>();
        for (ActivityEnrollDto aed : enrollList) {
            StringBuilder sb = new StringBuilder();
            sb.append(aed.getName()).append(",").append(aed.getMobile()).append(",");
            List<String> otherInfos = this.getOtherInfosFromJson(String.valueOf(aed.getContent()));
            if (GenericsUtils.notNullAndEmpty(otherInfos)) {
                for (String info : otherInfos) {
                    sb.append(info).append("/");
                }
                sb.deleteCharAt(sb.toString().length() - 1);
            } else {
                sb.append("\u65e0");
            }
            sb.append(",").append(DateUtil.getStrByDateFormate((Date)new Date(aed.getCreateTime()), (String)"yyyy/MM/dd HH:mm:ss"));
            rowLists.add(sb.toString());
        }
        csvContent.addRowBean(CsvUtils.RowBean.createTableType(heads, rowLists));
        return csvContent;
    }

    private List<String> getOtherInfosFromJson(String content) {
        return Arrays.asList(content.split(","));
    }

    @Override
    public ActivityRenderDto renderActivity(Long activityId, Integer orgId) {
        if (activityId == null) {
            return null;
        }
        Activity activity = this.activityDao.getActivityByIdAndOrgId(activityId, orgId);
        if (activity == null) {
            return null;
        }
        Map confMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(activityId));
        ActivityDetailDto tempDto = new ActivityDetailDto();
        if (activity != null && confMap != null) {
            tempDto = confMap.get(activityId) != null ? ActivityDetailDto.buildResponse(activity, (ActivityConf)confMap.get(activityId)) : ActivityDetailDto.buildResponse(activity);
        }
        ActivityRenderDto dto = new ActivityRenderDto();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)tempDto);
            int enrollCount = this.enrollDao.getEnrollCount(activityId.longValue());
            dto.setEnrollCount(enrollCount);
            OrgInfoSimpleDto simple = this.orgInfoService.getOrgInfo(Long.valueOf(activity.getOrgId().intValue()));
            dto.setOrgLogo(simple.getLogo());
            dto.setOrgName(simple.getShortName());
        }
        catch (Exception e) {
            this.logger.error("renderActivity error!", (Throwable)e);
        }
        return dto;
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void incrBrowseCount(Long activityId, Integer orgId) {
        Activity activity = this.activityDao.getActivityByIdAndOrgId(activityId, orgId);
        if (activity != null) {
            Integer browseCount = activity.getSupportNum();
            if (browseCount == null) {
                browseCount = 1;
            } else {
                Integer n = browseCount;
                Integer n2 = browseCount = Integer.valueOf(browseCount + 1);
            }
            activity.setSupportNum(browseCount);
            activity.setUpdateTime(DateUtil.getStrByDateFormate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.activityDao.update(activity);
            this.accessLogService.setTodayAccessCount(activityId, TemplateTypeCategory.COMMON_TYPE);
        }
    }
}

